/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractFlatSparseMatrix;
import dragon.matrix.AbstractSuperSparseMatrix;
import dragon.matrix.Cell;
import dragon.matrix.IntCell;
import dragon.matrix.IntFlatSparseMatrix;
import dragon.matrix.IntRow;
import dragon.matrix.IntSparseMatrix;
import dragon.matrix.Row;
import dragon.matrix.SparseMatrix;
import dragon.util.FileUtil;

public class IntSuperSparseMatrix
extends AbstractSuperSparseMatrix
implements IntSparseMatrix {
    private static final long serialVersionUID = 1L;

    public IntSuperSparseMatrix(String matrixFile) {
        super(null, matrixFile, IntCell.getCellDataLength());
    }

    public IntSuperSparseMatrix(String indexFile, String matrixFile) {
        super(indexFile, matrixFile, IntCell.getCellDataLength());
    }

    public IntSuperSparseMatrix(String matrixFile, boolean mergeMode, boolean miniMode) {
        super(null, matrixFile, IntCell.getCellDataLength(), mergeMode, miniMode);
    }

    public IntSuperSparseMatrix(String indexFile, String matrixFile, boolean mergeMode, boolean miniMode) {
        super(indexFile, matrixFile, IntCell.getCellDataLength(), mergeMode, miniMode);
    }

    public SparseMatrix createSparseMatrix() {
        String indexFile = FileUtil.getNewTempFilename("newmatrix", "index");
        String matrixFile = FileUtil.getNewTempFilename("newmatrix", "matrix");
        return new IntSuperSparseMatrix(indexFile, matrixFile, false, false);
    }

    protected AbstractFlatSparseMatrix createFlatSparseMatrix(boolean mergeMode, boolean miniMode) {
        return new IntFlatSparseMatrix(mergeMode, miniMode);
    }

    protected Row createRow(int row, int columns, byte[] data2) {
        IntRow cur = new IntRow();
        cur.load(row, columns, data2);
        return cur;
    }

    public Cell createCell(int row, int column, byte[] data2) {
        IntCell cur = new IntCell(row, column);
        cur.fromByteArray(data2);
        return cur;
    }

    public Cell createCell(int row, int column, String data2) {
        IntCell cur = new IntCell(row, column);
        cur.fromString(data2);
        return cur;
    }

    public boolean add(int row, int column, int score) {
        return this.add(new IntCell(row, column, score));
    }

    public int getInt(int row, int column) {
        if (row >= this.rows) {
            return 0;
        }
        return ((IntRow)this.getRow(row)).getInt(column);
    }

    public int getNonZeroIntScoreInRow(int row, int index) {
        if (row >= this.rows) {
            return 0;
        }
        return ((IntRow)this.getRow(row)).getNonZeroIntScore(index);
    }

    public int[] getNonZeroIntScoresInRow(int row) {
        if (row >= this.rows) {
            return null;
        }
        int[] oldArray = ((IntRow)this.getRow(row)).getNonZeroIntScores();
        int[] newArray = new int[oldArray.length];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    public double[] getNonZeroDoubleScoresInRow(int row) {
        if (row >= this.rows) {
            return null;
        }
        int[] oldArray = ((IntRow)this.getRow(row)).getNonZeroIntScores();
        if (oldArray == null) {
            return null;
        }
        double[] newArray = new double[oldArray.length];
        int i = 0;
        while (i < oldArray.length) {
            newArray[i] = oldArray[i];
            ++i;
        }
        return newArray;
    }

    public long getRowSum(int row) {
        long sum2 = 0L;
        int[] scores = this.getNonZeroIntScoresInRow(row);
        int count2 = 0;
        while (count2 < scores.length) {
            sum2 += (long)scores[count2];
            ++count2;
        }
        return sum2;
    }

    public long getColumnSum(int column) {
        return ((IntSuperSparseMatrix)this.transpose()).getRowSum(column);
    }
}

