/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractFlatSparseMatrix;
import dragon.matrix.Cell;
import dragon.matrix.DoubleCell;
import dragon.matrix.DoubleDenseMatrix;
import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.matrix.DoubleSparseMatrix;
import dragon.matrix.SparseMatrix;
import java.io.Serializable;

public class DoubleFlatSparseMatrix
extends AbstractFlatSparseMatrix
implements DoubleSparseMatrix,
Serializable {
    private static final long serialVersionUID = 1L;

    public DoubleFlatSparseMatrix() {
        super(false, false, DoubleCell.getCellDataLength());
    }

    public DoubleFlatSparseMatrix(boolean mergeMode, boolean miniMode) {
        super(mergeMode, miniMode, DoubleCell.getCellDataLength());
    }

    public DoubleFlatSparseMatrix(String filename) {
        super(false, false, DoubleCell.getCellDataLength());
        this.readTextMatrixFile(filename);
    }

    public DoubleFlatSparseMatrix(String filename, boolean binaryFile) {
        super(false, false, DoubleCell.getCellDataLength());
        if (binaryFile) {
            this.readBinaryMatrixFile(filename);
        } else {
            this.readTextMatrixFile(filename);
        }
    }

    public SparseMatrix createSparseMatrix() {
        return new DoubleFlatSparseMatrix();
    }

    public Cell createCell(int row, int column, byte[] data2) {
        DoubleCell cur = new DoubleCell(row, column);
        cur.fromByteArray(data2);
        return cur;
    }

    public Cell createCell(int row, int column, String data2) {
        DoubleCell cur = new DoubleCell(row, column);
        cur.fromString(data2);
        return cur;
    }

    public boolean add(int row, int column, double value2) {
        return this.add(new DoubleCell(row, column, value2));
    }

    public double get(int row, int column) {
        return this.getDouble(row, column);
    }

    public void set(int row, int column, double score) {
        this.setDouble(row, column, score);
    }

    public double getQuick(int row, int column) {
        return this.getDouble(row, column);
    }

    public void setQuick(int row, int column, double score) {
        this.setDouble(row, column, score);
    }

    public double getRowSum(int row) {
        double sum2 = 0.0;
        int num2 = this.getNonZeroNumInRow(row);
        int count2 = 0;
        while (count2 < num2) {
            sum2 += this.getNonZeroDoubleScoreInRow(row, count2);
            ++count2;
        }
        return sum2;
    }

    public double getColumnSum(int column) {
        return ((DoubleFlatSparseMatrix)this.transpose()).getRowSum(column);
    }

    public void normalizeColumns() {
        DoubleFlatSparseMatrix matrix = (DoubleFlatSparseMatrix)this.transpose();
        double[] arrNorm = new double[this.columns];
        int i = 0;
        while (i < matrix.rows()) {
            double score;
            arrNorm[i] = 0.0;
            int num2 = matrix.getNonZeroNumInRow(i);
            int j = 0;
            while (j < num2) {
                score = matrix.getNonZeroDoubleScoreInRow(i, j);
                int n = i;
                arrNorm[n] = arrNorm[n] + score * score;
                ++j;
            }
            arrNorm[i] = Math.sqrt(arrNorm[i]);
            j = 0;
            while (j < num2) {
                score = matrix.getNonZeroDoubleScoreInRow(i, j);
                matrix.setNonZeroDoubleScoreInRow(i, j, score);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.list.size()) {
            DoubleCell cur = (DoubleCell)this.getNonZeroCell(i);
            cur.setDoubleScore(cur.getDoubleScore() / arrNorm[cur.getColumn()]);
            ++i;
        }
    }

    public void normalizeRows() {
        ((DoubleFlatSparseMatrix)this.transpose()).normalizeColumns();
    }

    public DoubleDenseMatrix product(DoubleFlatSparseMatrix matrixY) {
        DoubleFlatSparseMatrix matrixX = this;
        if (matrixX.columns() != matrixY.rows()) {
            return null;
        }
        DoubleFlatDenseMatrix output2 = new DoubleFlatDenseMatrix(this.rows, matrixY.columns());
        int i = 0;
        while (i < matrixX.rows()) {
            int j = 0;
            while (j < matrixY.columns()) {
                double score = 0.0;
                int x2 = 0;
                int y = 0;
                int xNum = matrixX.getNonZeroNumInRow(i);
                int yNum = matrixY.getNonZeroNumInColumn(j);
                while (x2 < xNum && y < yNum) {
                    int yCol;
                    int xCol = matrixX.getNonZeroColumnInRow(i, x2);
                    if (xCol < (yCol = matrixY.getNonZeroRowInColumn(j, y))) {
                        ++x2;
                        continue;
                    }
                    if (xCol == yCol) {
                        score += matrixX.getNonZeroDoubleScoreInRow(i, ++x2) * matrixY.getNonZeroDoubleScoreInColumn(j, ++y);
                        continue;
                    }
                    ++y;
                }
                output2.setDouble(i, j, score);
                ++j;
            }
            ++i;
        }
        return output2;
    }

    public DoubleDenseMatrix product(DoubleDenseMatrix b) {
        DoubleFlatDenseMatrix output2 = new DoubleFlatDenseMatrix(this.rows, b.columns());
        int row = 0;
        while (row < this.rows()) {
            int[] arrColumn = this.getNonZeroColumnsInRow(row);
            double[] arrScore = this.getNonZeroDoubleScoresInRow(row);
            int col = 0;
            while (col < b.columns()) {
                double score = 0.0;
                int i = 0;
                while (i < arrColumn.length) {
                    score += arrScore[i] * b.getDouble(arrColumn[i], col);
                    ++i;
                }
                output2.setDouble(row, col, score);
                ++col;
            }
            ++row;
        }
        return output2;
    }
}

