/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractCell;
import dragon.matrix.Cell;
import dragon.util.ByteArrayConvert;
import java.io.Serializable;

public class DoubleCell
extends AbstractCell
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int row;
    protected int col;
    protected double score;

    public DoubleCell(int row, int column) {
        this.row = row;
        this.col = column;
        this.score = 0.0;
    }

    public DoubleCell(int row, int column, double score) {
        this.row = row;
        this.col = column;
        this.score = score;
    }

    public static int getCellDataLength() {
        return 8;
    }

    public void merge(Cell cell) {
        this.score = cell.getResetOption() ? cell.getDoubleScore() : (this.score += cell.getDoubleScore());
    }

    public byte[] toByteArray() {
        return ByteArrayConvert.toByte(this.score);
    }

    public void fromByteArray(byte[] data2) {
        this.score = ByteArrayConvert.toDouble(data2);
    }

    public String toString() {
        return String.valueOf(this.score);
    }

    public void fromString(String data2) {
        this.score = Double.parseDouble(data2);
    }

    public Cell transpose() {
        return new DoubleCell(this.col, this.row, this.score);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.col;
    }

    public double getDoubleScore() {
        return this.score;
    }

    public int getIntScore() {
        return (int)this.score;
    }

    public long getLongScore() {
        return (long)this.score;
    }

    public byte getByteScore() {
        return (byte)this.score;
    }

    public void setDoubleScore(double score) {
        this.score = score;
    }

    public void setIntScore(int score) {
        this.score = score;
    }

    public void setLongScore(long score) {
        this.score = score;
    }

    public void setByteScore(byte score) {
        this.score = score;
    }
}

