/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractFlatSparseMatrix;
import dragon.matrix.AbstractSparseMatrix;
import dragon.matrix.Cell;
import dragon.matrix.Row;
import dragon.matrix.SparseMatrixFactory;
import dragon.util.FastBinaryReader;
import dragon.util.FileUtil;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractSuperSparseMatrix
extends AbstractSparseMatrix {
    private static int DEFAULT_CACHESIZE = 10000;
    private static int DEFAULT_FLUSHINTERVAL = 1000000;
    protected String matrixFilename;
    protected String indexFilename;
    protected int totalCell;
    protected RandomAccessFile matrix;
    protected long[] arrRowPosInFile;
    protected int cacheSize;
    protected Row[] arrCachedRow;
    protected float[] arrRowLoadFactor;
    protected int[] arrRowPosInCache;
    protected int[] arrRowStart;
    protected int firstEmpty;
    protected AbstractFlatSparseMatrix cacheMatrix;
    protected int flushInterval;
    protected SparseMatrixFactory matrixFactory;

    protected abstract Row createRow(int var1, int var2, byte[] var3);

    protected abstract AbstractFlatSparseMatrix createFlatSparseMatrix(boolean var1, boolean var2);

    public AbstractSuperSparseMatrix(String indexFilename, String matrixFilename, int cellDataLength, boolean mergeMode, boolean miniMode) {
        super(mergeMode, miniMode, cellDataLength);
        this.indexFilename = indexFilename;
        this.matrixFilename = matrixFilename;
        this.matrixFactory = new SparseMatrixFactory(matrixFilename, cellDataLength);
        this.flushInterval = DEFAULT_FLUSHINTERVAL;
        this.isFinalized = false;
        this.cacheMatrix = this.createFlatSparseMatrix(mergeMode, miniMode);
        this.matrix = null;
        this.arrRowPosInFile = null;
        this.arrCachedRow = null;
        this.arrRowLoadFactor = null;
        this.arrRowPosInCache = null;
        this.arrRowStart = null;
        this.firstEmpty = 0;
        this.cacheSize = 0;
    }

    public AbstractSuperSparseMatrix(String indexFilename, String matrixFilename, int cellDataLength) {
        super(false, false, cellDataLength);
        this.indexFilename = indexFilename;
        this.matrixFilename = matrixFilename;
        this.matrixFactory = null;
        this.flushInterval = 0;
        this.isFinalized = true;
        this.cacheMatrix = null;
        this.matrix = null;
        this.arrRowPosInFile = null;
        this.arrCachedRow = null;
        this.arrRowLoadFactor = null;
        this.arrRowPosInCache = null;
        this.arrRowStart = null;
        this.firstEmpty = 0;
        this.cacheSize = 0;
        this.initData(DEFAULT_CACHESIZE);
    }

    private void initData(int cacheSize) {
        if (this.indexFilename != null && FileUtil.exist(this.indexFilename)) {
            this.readIndexFile(this.indexFilename);
        } else if (FileUtil.exist(this.matrixFilename)) {
            this.readIndexFromMatrix(this.matrixFilename);
        }
        try {
            if (FileUtil.exist(this.matrixFilename)) {
                this.matrix = new RandomAccessFile(this.matrixFilename, "r");
                this.setCache(cacheSize);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCache(int cacheSize) {
        if (cacheSize <= 0) {
            cacheSize = DEFAULT_CACHESIZE;
        }
        if (this.arrCachedRow == null) {
            this.cacheSize = cacheSize;
            this.arrCachedRow = new Row[cacheSize];
            this.firstEmpty = 0;
        }
    }

    public void setFlushInterval(int interval) {
        this.flushInterval = interval;
    }

    public void close() {
        try {
            this.totalCell = 0;
            if (this.matrix != null) {
                this.matrix.close();
            }
            this.arrRowPosInFile = null;
            this.arrRowPosInFile = null;
            this.cacheSize = 0;
            this.arrCachedRow = null;
            this.arrRowLoadFactor = null;
            this.arrRowStart = null;
            this.firstEmpty = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean add(Cell cell) {
        if (this.isFinalized) {
            return false;
        }
        this.cacheMatrix.add(cell);
        if (this.cacheMatrix.getNonZeroNum() >= this.flushInterval) {
            this.flush();
        }
        return true;
    }

    public void flush() {
        this.cacheMatrix.finalizeData(true);
        this.matrixFactory.add(this.cacheMatrix);
        this.cacheMatrix.close();
    }

    public boolean finalizeData(boolean sorting) {
        if (this.isFinalized) {
            return false;
        }
        this.flush();
        this.columns = this.matrixFactory.columns();
        this.rows = this.matrixFactory.rows();
        this.totalCell = this.matrixFactory.getNonZeroNum();
        this.isFinalized = true;
        if (this.indexFilename != null) {
            this.matrixFactory.genIndexFile(this.indexFilename);
        }
        if (!this.matrixFactory.getMatrixFilename().equalsIgnoreCase(this.matrixFilename)) {
            File file = new File(this.matrixFilename);
            file.delete();
            new File(this.matrixFactory.getMatrixFilename()).renameTo(file);
        }
        return true;
    }

    public String getMatrixFilename() {
        return this.matrixFilename;
    }

    public String getIndexFilename() {
        return this.indexFilename;
    }

    public int getNonZeroNum() {
        return this.totalCell;
    }

    public int getNonZeroNumInRow(int row) {
        if (row >= this.rows) {
            return 0;
        }
        if (this.arrRowStart == null) {
            this.initData(this.cacheSize);
        }
        return this.arrRowStart[row + 1] - this.arrRowStart[row];
    }

    public int getNonZeroColumnInRow(int row, int index) {
        return this.getRow(row).getNonZeroColumn(index);
    }

    public int[] getNonZeroColumnsInRow(int row) {
        if (row >= this.rows) {
            return null;
        }
        int[] oldArray = this.getRow(row).getNonZeroColumns();
        int[] newArray = new int[oldArray.length];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    public Cell getCell(int row, int col) {
        if (row >= this.rows) {
            return null;
        }
        return this.getRow(row).getCell(col);
    }

    public Cell getNonZeroCellInRow(int row, int index) {
        return this.getRow(row).getNonZeroCell(index);
    }

    protected Row getRow(int index) {
        if (this.arrRowStart == null) {
            this.initData(this.cacheSize);
        }
        if (this.arrRowPosInCache[index] >= 0) {
            return this.arrCachedRow[this.arrRowPosInCache[index]];
        }
        return this.loadRow(index, this.getRoomInCache());
    }

    private Row loadRow(int index, int posInCache) {
        try {
            int n = index;
            this.arrRowLoadFactor[n] = (float)((double)this.arrRowLoadFactor[n] + 0.1 * Math.log(this.arrRowStart[index + 1] - this.arrRowStart[index]));
            Row curRow = this.arrCachedRow[posInCache];
            if (curRow != null) {
                this.arrRowPosInCache[curRow.getRowIndex()] = -1;
            }
            this.matrix.seek(this.arrRowPosInFile[index]);
            this.matrix.readInt();
            int len = this.matrix.readInt();
            byte[] data2 = new byte[len * (this.getCellDataLength() + 4)];
            this.matrix.read(data2);
            if (curRow != null) {
                curRow.load(index, len, data2);
                curRow.setLoadFactor(this.arrRowLoadFactor[index]);
            } else {
                curRow = this.createRow(index, len, data2);
                curRow.setLoadFactor(this.arrRowLoadFactor[index]);
                this.arrCachedRow[posInCache] = curRow;
            }
            this.arrRowPosInCache[index] = posInCache;
            return curRow;
        }
        catch (Exception e) {
            return null;
        }
    }

    private int getRoomInCache() {
        Row row;
        if (this.firstEmpty >= 0) {
            int pos = this.firstEmpty++;
            if (this.firstEmpty >= this.cacheSize) {
                this.firstEmpty = -1;
            }
            return pos;
        }
        ArrayList<Row> list2 = new ArrayList<Row>(this.cacheSize);
        int i = 0;
        while (i < this.cacheSize) {
            list2.add(this.arrCachedRow[i]);
            ++i;
        }
        Collections.sort(list2);
        int breakpoint = (int)((double)this.cacheSize * 0.9);
        i = 0;
        while (i < breakpoint) {
            row = (Row)list2.get(i);
            this.arrRowPosInCache[row.getRowIndex()] = i;
            this.arrCachedRow[i] = row;
            ++i;
        }
        i = breakpoint;
        while (i < this.cacheSize) {
            row = (Row)list2.get(i);
            this.arrRowPosInCache[row.getRowIndex()] = -1;
            this.arrCachedRow[i] = null;
            ++i;
        }
        int pos = breakpoint;
        this.firstEmpty = pos + 1;
        return pos;
    }

    private void readIndexFile(String filename) {
        try {
            FastBinaryReader reader = new FastBinaryReader(filename);
            this.rows = reader.readInt();
            this.columns = reader.readInt();
            this.totalCell = reader.readInt();
            this.arrRowLoadFactor = new float[this.rows];
            this.arrRowPosInCache = new int[this.rows];
            this.arrRowPosInFile = new long[this.rows + 1];
            this.arrRowStart = new int[this.rows + 1];
            this.arrRowStart[0] = 0;
            int i = 0;
            while (i < this.rows) {
                int row = reader.readInt();
                long offset = reader.readLong();
                int freq = reader.readInt();
                this.arrRowLoadFactor[row] = (float)Math.log(freq);
                this.arrRowPosInCache[row] = -1;
                this.arrRowPosInFile[row] = offset;
                this.arrRowStart[row + 1] = this.arrRowStart[row] + freq;
                ++i;
            }
            this.arrRowPosInFile[this.rows] = this.arrRowPosInFile[this.rows - 1] + (long)((this.arrRowStart[this.rows] - this.arrRowStart[this.rows - 1]) * (this.cellDataLength + 4)) + 8L;
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readIndexFromMatrix(String filename) {
        try {
            RandomAccessFile raf = new RandomAccessFile(filename, "r");
            this.rows = raf.readInt();
            this.columns = raf.readInt();
            this.totalCell = raf.readInt();
            this.arrRowLoadFactor = new float[this.rows];
            this.arrRowPosInCache = new int[this.rows];
            this.arrRowPosInFile = new long[this.rows + 1];
            this.arrRowStart = new int[this.rows + 1];
            this.arrRowStart[0] = 0;
            int i = 0;
            while (i < this.rows) {
                long offset = raf.getFilePointer();
                int row = raf.readInt();
                int freq = raf.readInt();
                this.arrRowLoadFactor[row] = (float)Math.log(freq);
                this.arrRowPosInCache[row] = -1;
                this.arrRowPosInFile[row] = offset;
                this.arrRowStart[row + 1] = this.arrRowStart[row] + freq;
                raf.skipBytes(freq * (this.cellDataLength + 4));
                ++i;
            }
            this.arrRowPosInFile[this.rows] = raf.getFilePointer();
            raf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

