/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractMatrix;
import dragon.matrix.DenseMatrix;
import java.io.Serializable;

public abstract class AbstractDenseMatrix
extends AbstractMatrix
implements DenseMatrix,
Serializable {
    public AbstractDenseMatrix(int row, int column, int cellDataLength) {
        this.rows = row;
        this.columns = column;
        this.cellDataLength = cellDataLength;
    }

    public double cosine(int rowA, int rowB) {
        int productSum = 0;
        int vLenA = 0;
        int vLenB = 0;
        int i = 0;
        while (i < this.columns) {
            if (this.cellDataLength == 8) {
                productSum = (int)((double)productSum + this.getDouble(rowA, i) * this.getDouble(rowB, i));
                vLenA = (int)((double)vLenA + this.getDouble(rowA, i) * this.getDouble(rowA, i));
                vLenB = (int)((double)vLenB + this.getDouble(rowB, i) * this.getDouble(rowB, i));
            } else {
                productSum += this.getInt(rowA, i) * this.getInt(rowB, i);
                vLenA += this.getInt(rowA, i) * this.getInt(rowA, i);
                vLenB += this.getInt(rowB, i) * this.getInt(rowB, i);
            }
            ++i;
        }
        return (double)productSum / Math.sqrt(vLenA) * Math.sqrt(vLenB);
    }

    public int getCooccurrenceCount(int rowA, int rowB) {
        int i = 0;
        int coOccurCount = 0;
        while (i < this.columns) {
            if (this.cellDataLength == 8) {
                if (this.getDouble(rowA, i) != 0.0 && this.getDouble(rowB, i) != 0.0) {
                    ++coOccurCount;
                } else if (this.getInt(rowA, i) != 0 && this.getInt(rowB, i) != 0) {
                    ++coOccurCount;
                }
            }
            ++i;
        }
        return coOccurCount;
    }
}

