/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.topicmodel;

import dragon.ir.index.IndexReader;
import dragon.ir.topicmodel.AbstractTwoDimensionModel;
import java.util.Date;
import java.util.Random;

public class TwoDimensionGibbsLDA
extends AbstractTwoDimensionModel {
    private double alpha;
    private double beta;
    private double wBeta;
    private double gamma0;
    private double gamma1;
    private double delta;
    private double wDelta;
    private double epsilon;
    private double wEpsilon;
    private double rho;
    private int tokenNumO;
    private int tokenNumP;

    public TwoDimensionGibbsLDA(IndexReader viewIndexReader, IndexReader topicIndexReader, double alpha, double beta, double gamma0, double gamma1, double delta, double epsilon, double rho) {
        super(viewIndexReader, topicIndexReader);
        this.seed = -1;
        this.iterations = 1000;
        this.alpha = alpha;
        this.beta = beta;
        this.gamma0 = gamma0;
        this.delta = delta;
        this.epsilon = epsilon;
        this.rho = rho;
        this.tokenNumO = (int)viewIndexReader.getCollection().getTermCount();
        this.tokenNumP = (int)viewIndexReader.getCollection().getTermCount();
        this.wBeta = beta * (double)(this.viewTermNum + this.themeTermNum);
        this.wDelta = delta * (double)this.themeTermNum;
        this.wEpsilon = epsilon * (double)this.themeTermNum;
    }

    public boolean estimateModel(int viewNum, int topicNum) {
        int j;
        double sum2;
        this.viewNum = viewNum;
        this.themeNum = topicNum;
        int[] arrTermO = new int[this.tokenNumO];
        int[] arrDocO = new int[this.tokenNumO];
        int[] arrTermP = new int[this.tokenNumP];
        int[] arrDocP = new int[this.tokenNumP];
        int[] arrZO = new int[this.tokenNumO];
        int[] arrZP = new int[this.tokenNumP];
        int[] arrY = new int[this.tokenNumP];
        int[] arrX = new int[this.tokenNumP];
        int[][] arrTVCountO = new int[this.viewTermNum][viewNum];
        int[][] arrTVCountP = new int[this.themeTermNum][viewNum];
        int[][] arrDVCount = new int[this.docNum][viewNum];
        int[][] arrTTCount = new int[this.themeTermNum][this.themeNum];
        int[][][] arrTTViewCount = new int[this.themeTermNum][viewNum][this.themeNum];
        int[][][] arrTTComCount = new int[this.themeTermNum][viewNum][this.themeNum];
        int[][][] arrDTCount = new int[this.docNum][viewNum][this.themeNum];
        this.arrViewProb = new double[viewNum][this.viewTermNum];
        this.arrDocView = new double[this.docNum][viewNum];
        this.arrThemeProb = new double[viewNum][this.themeNum][this.themeTermNum];
        this.arrDocTheme = new double[this.docNum][viewNum][this.themeNum];
        this.arrCommonThemeProb = new double[this.themeNum][this.themeTermNum];
        this.readSequence(this.viewIndexReader, arrTermO, arrDocO);
        this.readSequence(this.topicIndexReader, arrTermP, arrDocP);
        this.run(this.seed, arrTermO, arrDocO, arrZO, arrTVCountO, arrTermP, arrDocP, arrZP, arrTVCountP, arrDVCount, arrY, arrX, arrTTViewCount, arrTTComCount, arrTTCount, arrDTCount);
        int i = 0;
        while (i < viewNum) {
            sum2 = this.beta * (double)this.viewTermNum;
            j = 0;
            while (j < this.viewTermNum) {
                sum2 += (double)arrTVCountO[j][i];
                ++j;
            }
            j = 0;
            while (j < this.viewTermNum) {
                this.arrViewProb[i][j] = ((double)arrTVCountO[j][i] + this.beta) / sum2;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.docNum) {
            sum2 = (double)viewNum * this.alpha;
            j = 0;
            while (j < viewNum) {
                sum2 += (double)arrDVCount[i][j];
                ++j;
            }
            j = 0;
            while (j < viewNum) {
                this.arrDocView[i][j] = ((double)arrDVCount[i][j] + this.alpha) / sum2;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.themeNum) {
            sum2 = this.delta * (double)this.themeTermNum;
            j = 0;
            while (j < this.themeTermNum) {
                sum2 += (double)arrTTCount[j][i];
                ++j;
            }
            j = 0;
            while (j < this.themeTermNum) {
                this.arrCommonThemeProb[i][j] = ((double)arrTTCount[j][i] + this.delta) / sum2;
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < viewNum) {
            i = 0;
            while (i < this.themeNum) {
                sum2 = this.epsilon * (double)this.themeTermNum;
                j = 0;
                while (j < this.themeTermNum) {
                    sum2 += (double)arrTTViewCount[j][k][i];
                    ++j;
                }
                j = 0;
                while (j < this.themeTermNum) {
                    this.arrThemeProb[k][i][j] = ((double)arrTTViewCount[j][k][i] + this.epsilon) / sum2;
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        k = 0;
        while (k < this.docNum) {
            i = 0;
            while (i < viewNum) {
                sum2 = this.rho * (double)this.themeNum;
                j = 0;
                while (j < this.themeNum) {
                    sum2 += (double)arrDTCount[k][i][j];
                    ++j;
                }
                j = 0;
                while (j < this.themeNum) {
                    this.arrDocTheme[k][i][j] = ((double)arrDTCount[k][i][j] + this.rho) / sum2;
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        return true;
    }

    private void run(int seed, int[] arrTermO, int[] arrDocO, int[] arrZO, int[][] arrTVCountO, int[] arrTermP, int[] arrDocP, int[] arrZP, int[][] arrTVCountP, int[][] arrDVCount, int[] arrY, int[] arrX, int[][][] arrTTViewCount, int[][][] arrTTComCount, int[][] arrTTCount, int[][][] arrDTCount) {
        int j;
        int k;
        int topic;
        int docIndex;
        int termIndex;
        int view;
        int[] arrViewCount = new int[this.viewNum];
        int[] arrTopicCount = new int[this.themeNum];
        int[][] arrViewTopicCount = new int[this.viewNum][this.themeNum];
        int[] arrOrderO = new int[this.tokenNumO];
        int[] arrOrderP = new int[this.tokenNumP];
        Random random = new Random();
        if (seed >= 0) {
            random.setSeed(seed);
        }
        this.printStatus(new Date().toString() + " Starting random initialization...");
        int i = 0;
        while (i < this.tokenNumO) {
            arrZO[i] = view = random.nextInt(this.viewNum);
            termIndex = arrTermO[i];
            docIndex = arrDocO[i];
            int[] nArray = arrTVCountO[termIndex];
            int n = view;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = arrDVCount[docIndex];
            int n2 = view;
            nArray2[n2] = nArray2[n2] + 1;
            int n3 = view;
            arrViewCount[n3] = arrViewCount[n3] + 1;
            ++i;
        }
        i = 0;
        while (i < this.tokenNumP) {
            arrZP[i] = view = random.nextInt(this.viewNum);
            termIndex = arrTermP[i];
            docIndex = arrDocP[i];
            int[] nArray = arrTVCountP[termIndex];
            int n = view;
            nArray[n] = nArray[n] + 1;
            int[] nArray3 = arrDVCount[docIndex];
            int n4 = view;
            nArray3[n4] = nArray3[n4] + 1;
            int n5 = view;
            arrViewCount[n5] = arrViewCount[n5] + 1;
            ++i;
        }
        i = 0;
        while (i < this.tokenNumP) {
            topic = random.nextInt(this.themeNum);
            view = arrZP[i];
            arrY[i] = topic;
            termIndex = arrTermP[i];
            docIndex = arrDocP[i];
            int[] nArray = arrTTViewCount[termIndex][view];
            int n = topic;
            nArray[n] = nArray[n] + 1;
            int[] nArray4 = arrDTCount[docIndex][view];
            int n6 = topic;
            nArray4[n6] = nArray4[n6] + 1;
            int[] nArray5 = arrViewTopicCount[view];
            int n7 = topic;
            nArray5[n7] = nArray5[n7] + 1;
            arrX[i] = 1;
            ++i;
        }
        this.printStatus(new Date().toString() + " Determining random update sequence...");
        i = 0;
        while (i < this.tokenNumO) {
            arrOrderO[i] = i;
            ++i;
        }
        i = 0;
        while (i < this.tokenNumO - 1) {
            k = i + random.nextInt(this.tokenNumO - i);
            j = arrOrderO[k];
            arrOrderO[k] = arrOrderO[i];
            arrOrderO[i] = j;
            ++i;
        }
        i = 0;
        while (i < this.tokenNumP) {
            arrOrderP[i] = i;
            ++i;
        }
        i = 0;
        while (i < this.tokenNumP - 1) {
            k = i + random.nextInt(this.tokenNumP - i);
            j = arrOrderP[k];
            arrOrderP[k] = arrOrderP[i];
            arrOrderP[i] = j;
            ++i;
        }
        int iter2 = 0;
        while (iter2 < this.iterations) {
            this.printStatus(new Date().toString() + " Iteration #" + (iter2 + 1));
            k = 0;
            while (k < this.tokenNumO) {
                i = arrOrderO[k];
                termIndex = arrTermO[i];
                docIndex = arrDocO[i];
                int n = view = arrZO[i];
                arrViewCount[n] = arrViewCount[n] - 1;
                int[] nArray = arrTVCountO[termIndex];
                int n8 = view;
                nArray[n8] = nArray[n8] - 1;
                int[] nArray6 = arrDVCount[docIndex];
                int n9 = view;
                nArray6[n9] = nArray6[n9] - 1;
                arrZO[i] = view = this.sampleView(random, arrTVCountO[termIndex], arrDVCount[docIndex], arrViewCount);
                int[] nArray7 = arrTVCountO[termIndex];
                int n10 = view;
                nArray7[n10] = nArray7[n10] + 1;
                int[] nArray8 = arrDVCount[docIndex];
                int n11 = view;
                nArray8[n11] = nArray8[n11] + 1;
                int n12 = view;
                arrViewCount[n12] = arrViewCount[n12] + 1;
                ++k;
            }
            k = 0;
            while (k < this.tokenNumP) {
                i = arrOrderP[k];
                termIndex = arrTermP[i];
                docIndex = arrDocP[i];
                topic = arrY[i];
                view = arrZP[i];
                int status = arrX[i];
                int n = view;
                arrViewCount[n] = arrViewCount[n] - 1;
                int[] nArray = arrTVCountP[termIndex];
                int n13 = view;
                nArray[n13] = nArray[n13] - 1;
                int[] nArray9 = arrDVCount[docIndex];
                int n14 = view;
                nArray9[n14] = nArray9[n14] - 1;
                if (status == 0) {
                    int[] nArray10 = arrTTComCount[termIndex][view];
                    int n15 = topic;
                    nArray10[n15] = nArray10[n15] - 1;
                } else {
                    int[] nArray11 = arrTTViewCount[termIndex][view];
                    int n16 = topic;
                    nArray11[n16] = nArray11[n16] - 1;
                    int[] nArray12 = arrViewTopicCount[view];
                    int n17 = topic;
                    nArray12[n17] = nArray12[n17] - 1;
                }
                int[] nArray13 = arrDTCount[docIndex][view];
                int n18 = topic;
                nArray13[n18] = nArray13[n18] - 1;
                arrZP[i] = view = this.sampleView(random, arrTVCountP[termIndex], arrDVCount[docIndex], arrViewCount);
                int[] nArray14 = arrTVCountP[termIndex];
                int n19 = view;
                nArray14[n19] = nArray14[n19] + 1;
                int[] nArray15 = arrDVCount[docIndex];
                int n20 = view;
                nArray15[n20] = nArray15[n20] + 1;
                int n21 = view;
                arrViewCount[n21] = arrViewCount[n21] + 1;
                if (status == 0) {
                    int[] nArray16 = arrTTComCount[termIndex][view];
                    int n22 = topic;
                    nArray16[n22] = nArray16[n22] + 1;
                } else {
                    int[] nArray17 = arrTTViewCount[termIndex][view];
                    int n23 = topic;
                    nArray17[n23] = nArray17[n23] + 1;
                    int[] nArray18 = arrViewTopicCount[view];
                    int n24 = topic;
                    nArray18[n24] = nArray18[n24] + 1;
                }
                int[] nArray19 = arrDTCount[docIndex][view];
                int n25 = topic;
                nArray19[n25] = nArray19[n25] + 1;
                if (status == 0) {
                    int n26 = topic;
                    arrTopicCount[n26] = arrTopicCount[n26] - 1;
                    int[] nArray20 = arrTTCount[termIndex];
                    int n27 = topic;
                    nArray20[n27] = nArray20[n27] - 1;
                    int[] nArray21 = arrTTComCount[termIndex][view];
                    int n28 = topic;
                    nArray21[n28] = nArray21[n28] - 1;
                    int[] nArray22 = arrDTCount[docIndex][view];
                    int n29 = topic;
                    nArray22[n29] = nArray22[n29] - 1;
                    arrY[i] = topic = this.sampleCommonTopic(random, arrTTCount[termIndex], arrDTCount[docIndex][view], arrTopicCount);
                    int[] nArray23 = arrTTComCount[termIndex][view];
                    int n30 = topic;
                    nArray23[n30] = nArray23[n30] + 1;
                    int[] nArray24 = arrTTCount[termIndex];
                    int n31 = topic;
                    nArray24[n31] = nArray24[n31] + 1;
                    int[] nArray25 = arrDTCount[docIndex][view];
                    int n32 = topic;
                    nArray25[n32] = nArray25[n32] + 1;
                    int n33 = topic;
                    arrTopicCount[n33] = arrTopicCount[n33] + 1;
                } else {
                    int[] nArray26 = arrViewTopicCount[view];
                    int n34 = topic;
                    nArray26[n34] = nArray26[n34] - 1;
                    int[] nArray27 = arrTTViewCount[termIndex][view];
                    int n35 = topic;
                    nArray27[n35] = nArray27[n35] - 1;
                    int[] nArray28 = arrDTCount[docIndex][view];
                    int n36 = topic;
                    nArray28[n36] = nArray28[n36] - 1;
                    arrY[i] = topic = this.sampleViewTopic(random, arrTTViewCount[termIndex][view], arrDTCount[docIndex][view], arrViewTopicCount[view]);
                    int[] nArray29 = arrTTViewCount[termIndex][view];
                    int n37 = topic;
                    nArray29[n37] = nArray29[n37] + 1;
                    int[] nArray30 = arrDTCount[docIndex][view];
                    int n38 = topic;
                    nArray30[n38] = nArray30[n38] + 1;
                    int[] nArray31 = arrViewTopicCount[view];
                    int n39 = topic;
                    nArray31[n39] = nArray31[n39] + 1;
                }
                if (status == 0) {
                    int n40 = topic;
                    arrTopicCount[n40] = arrTopicCount[n40] - 1;
                    int[] nArray32 = arrTTCount[termIndex];
                    int n41 = topic;
                    nArray32[n41] = nArray32[n41] - 1;
                    int[] nArray33 = arrTTComCount[termIndex][view];
                    int n42 = topic;
                    nArray33[n42] = nArray33[n42] - 1;
                    int[] nArray34 = arrDTCount[docIndex][view];
                    int n43 = topic;
                    nArray34[n43] = nArray34[n43] - 1;
                } else {
                    int[] nArray35 = arrViewTopicCount[view];
                    int n44 = topic;
                    nArray35[n44] = nArray35[n44] - 1;
                    int[] nArray36 = arrTTViewCount[termIndex][view];
                    int n45 = topic;
                    nArray36[n45] = nArray36[n45] - 1;
                    int[] nArray37 = arrDTCount[docIndex][view];
                    int n46 = topic;
                    nArray37[n46] = nArray37[n46] - 1;
                }
                arrX[i] = status = this.sampleStatus(random, arrTTViewCount[termIndex][view][topic], arrViewTopicCount[view][topic], arrTTComCount[termIndex][view][topic], arrTTCount[termIndex][topic], arrTopicCount[topic]);
                if (status == 0) {
                    int[] nArray38 = arrTTComCount[termIndex][view];
                    int n47 = topic;
                    nArray38[n47] = nArray38[n47] + 1;
                    int[] nArray39 = arrTTCount[termIndex];
                    int n48 = topic;
                    nArray39[n48] = nArray39[n48] + 1;
                    int[] nArray40 = arrDTCount[docIndex][view];
                    int n49 = topic;
                    nArray40[n49] = nArray40[n49] + 1;
                    int n50 = topic;
                    arrTopicCount[n50] = arrTopicCount[n50] + 1;
                } else {
                    int[] nArray41 = arrTTViewCount[termIndex][view];
                    int n51 = topic;
                    nArray41[n51] = nArray41[n51] + 1;
                    int[] nArray42 = arrDTCount[docIndex][view];
                    int n52 = topic;
                    nArray42[n52] = nArray42[n52] + 1;
                    int[] nArray43 = arrViewTopicCount[view];
                    int n53 = topic;
                    nArray43[n53] = nArray43[n53] + 1;
                }
                ++k;
            }
            ++iter2;
        }
    }

    private int sampleView(Random random, int[] arrTVCount, int[] arrDVCount, int[] arrViewCount) {
        double totalProb = 0.0;
        double[] arrProb = new double[this.viewNum];
        int j = 0;
        while (j < this.viewNum) {
            arrProb[j] = ((double)arrTVCount[j] + this.beta) / ((double)arrViewCount[j] + this.wBeta) * ((double)arrDVCount[j] + this.alpha);
            totalProb += arrProb[j];
            ++j;
        }
        double r = totalProb * random.nextDouble();
        double max2 = arrProb[0];
        int view = 0;
        while (r > max2) {
            max2 += arrProb[++view];
        }
        return view;
    }

    private int sampleCommonTopic(Random random, int[] arrTTCount, int[] arrDTCount, int[] arrTopicCount) {
        double totalProb = 0.0;
        double[] arrProb = new double[this.themeNum];
        int j = 0;
        while (j < this.themeNum) {
            arrProb[j] = ((double)arrTTCount[j] + this.delta) / ((double)arrTopicCount[j] + this.wDelta) * ((double)arrDTCount[j] + this.rho);
            totalProb += arrProb[j];
            ++j;
        }
        double r = totalProb * random.nextDouble();
        double max2 = arrProb[0];
        int topic = 0;
        while (r > max2) {
            max2 += arrProb[++topic];
        }
        return topic;
    }

    private int sampleViewTopic(Random random, int[] arrTTViewCount, int[] arrDTCount, int[] arrViewTopicCount) {
        double totalProb = 0.0;
        double[] arrProb = new double[this.themeNum];
        int j = 0;
        while (j < this.themeNum) {
            arrProb[j] = ((double)arrTTViewCount[j] + this.epsilon) / ((double)arrViewTopicCount[j] + this.wEpsilon) * ((double)arrDTCount[j] + this.rho);
            totalProb += arrProb[j];
            ++j;
        }
        double r = totalProb * random.nextDouble();
        double max2 = arrProb[0];
        int topic = 0;
        while (r > max2) {
            max2 += arrProb[++topic];
        }
        return topic;
    }

    private int sampleStatus(Random random, int ttViewCount, int sumTTViewCount, int ttCommonCount, int ttCount, int sumTTCount) {
        double x0 = (this.gamma0 + (double)ttCommonCount) * ((double)ttCount + this.delta) / ((double)sumTTCount + this.wDelta);
        double x1 = (this.gamma1 + (double)ttViewCount) * ((double)ttViewCount + this.epsilon) / ((double)sumTTViewCount + this.wEpsilon);
        x0 /= x0 + x1;
        double prob = random.nextDouble();
        if (prob <= x0) {
            return 0;
        }
        return 1;
    }

    private void readSequence(IndexReader indexReader, int[] arrTerm, int[] arrDoc) {
        int docNum = indexReader.getCollection().getDocNum();
        int count2 = 0;
        int i = 0;
        while (i < docNum) {
            int[] arrIndex = indexReader.getTermIndexList(i);
            int[] arrFreq = indexReader.getTermFrequencyList(i);
            if (arrIndex != null && arrIndex.length != 0) {
                int j = 0;
                while (j < arrIndex.length) {
                    int k = 0;
                    while (k < arrFreq[j]) {
                        arrTerm[count2 + k] = arrIndex[j];
                        arrDoc[count2 + k] = i;
                        ++k;
                    }
                    count2 += arrFreq[j];
                    ++j;
                }
            }
            ++i;
        }
    }
}

