/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.topicmodel;

import dragon.ir.index.IndexReader;
import dragon.ir.topicmodel.AbstractTwoDimensionModel;
import dragon.matrix.vector.DoubleVector;
import java.util.Random;

public class TwoDimensionEM
extends AbstractTwoDimensionModel {
    protected DoubleVector viewBkgModel;
    protected DoubleVector themeBkgModel;
    protected double viewBkgCoeffi;
    protected double themeBkgCoeffi;
    protected double comThemeCoeffi;

    public TwoDimensionEM(IndexReader viewIndexReader, IndexReader topicIndexReader, double viewBkgCoeffi, double themeBkgCoeffi, double comThemeCoeffi) {
        this(viewIndexReader, null, viewBkgCoeffi, topicIndexReader, null, themeBkgCoeffi, comThemeCoeffi);
    }

    public TwoDimensionEM(IndexReader viewIndexReader, DoubleVector viewBkgModel, double viewBkgCoeffi, IndexReader topicIndexReader, DoubleVector themeBkgModel, double themeBkgCoeffi, double comThemeCoeffi) {
        super(viewIndexReader, topicIndexReader);
        viewBkgModel = viewBkgModel == null ? this.getBkgModel(viewIndexReader) : viewBkgModel.copy();
        this.viewBkgCoeffi = viewBkgCoeffi;
        this.viewBkgModel.multiply(viewBkgCoeffi);
        themeBkgModel = themeBkgModel == null ? this.getBkgModel(topicIndexReader) : themeBkgModel.copy();
        this.themeBkgCoeffi = themeBkgCoeffi;
        this.themeBkgModel.multiply(themeBkgCoeffi);
        this.comThemeCoeffi = comThemeCoeffi;
    }

    public boolean estimateModel(int viewNum, int topicNum) {
        this.viewNum = viewNum;
        this.themeNum = topicNum;
        this.arrViewProb = new double[viewNum][this.viewTermNum];
        double[][] arrTempViewProb = new double[viewNum][this.viewTermNum];
        this.arrDocView = new double[this.docNum][viewNum];
        double[] arrDocViewSum = new double[viewNum];
        double[] arrViewProbSum = new double[viewNum];
        this.arrThemeProb = new double[viewNum][this.themeNum][this.themeTermNum];
        double[][][] arrTempThemeProb = new double[viewNum][this.themeNum][this.themeTermNum];
        this.arrCommonThemeProb = new double[this.themeNum][this.themeTermNum];
        double[][] arrTempThemeCommonProb = new double[this.themeNum][this.themeTermNum];
        this.arrDocTheme = new double[this.docNum][viewNum][this.themeNum];
        double[][] arrDocThemeSum = new double[viewNum][this.themeNum];
        this.initialize(this.docNum, this.viewTermNum, viewNum, this.arrViewProb, this.arrDocView, this.themeTermNum, this.themeNum, this.arrCommonThemeProb, this.arrThemeProb, this.arrDocTheme);
        this.printStatus("Estimating the coefficients of two-dimensional mixture model...");
        int k = 0;
        while (k < this.iterations) {
            double termProbSum;
            int i;
            this.printStatus("Iteration #" + (k + 1));
            int m = 0;
            while (m < viewNum) {
                i = 0;
                while (i < this.viewTermNum) {
                    arrTempViewProb[m][i] = 0.0;
                    ++i;
                }
                ++m;
            }
            int l = 0;
            while (l < this.themeNum) {
                i = 0;
                while (i < this.themeTermNum) {
                    arrTempThemeCommonProb[l][i] = 0.0;
                    ++i;
                }
                ++l;
            }
            m = 0;
            while (m < viewNum) {
                l = 0;
                while (l < this.themeNum) {
                    i = 0;
                    while (i < this.themeTermNum) {
                        arrTempThemeProb[m][l][i] = 0.0;
                        ++i;
                    }
                    ++l;
                }
                ++m;
            }
            i = 0;
            while (i < this.docNum) {
                double docWeightSum;
                double termProb;
                double themeProb;
                double themeProbSum;
                int termIndex;
                m = 0;
                while (m < viewNum) {
                    arrDocViewSum[m] = 0.0;
                    ++m;
                }
                m = 0;
                while (m < viewNum) {
                    l = 0;
                    while (l < this.themeNum) {
                        arrDocThemeSum[m][l] = 0.0;
                        ++l;
                    }
                    ++m;
                }
                int[] arrIndex = this.topicIndexReader.getTermIndexList(i);
                int[] arrFreq = this.topicIndexReader.getTermFrequencyList(i);
                int j = 0;
                while (j < arrIndex.length) {
                    termIndex = arrIndex[j];
                    themeProbSum = 0.0;
                    m = 0;
                    while (m < viewNum) {
                        arrViewProbSum[m] = 0.0;
                        l = 0;
                        while (l < this.themeNum) {
                            int n = m;
                            arrViewProbSum[n] = arrViewProbSum[n] + ((1.0 - this.comThemeCoeffi) * this.arrThemeProb[m][l][termIndex] + this.comThemeCoeffi * this.arrCommonThemeProb[l][termIndex]) * this.arrDocTheme[i][m][l];
                            ++l;
                        }
                        arrViewProbSum[m] = arrViewProbSum[m] * this.arrDocView[i][m];
                        themeProbSum += arrViewProbSum[m];
                        ++m;
                    }
                    double themeBkgProb = themeProbSum != 0.0 ? this.themeBkgModel.get(termIndex) / (themeProbSum * (1.0 - this.themeBkgCoeffi) + this.themeBkgModel.get(termIndex)) : 0.0;
                    m = 0;
                    while (m < viewNum) {
                        if (themeProbSum != 0.0) {
                            int n = m;
                            arrDocViewSum[n] = arrDocViewSum[n] + (double)arrFreq[j] * arrViewProbSum[m] / themeProbSum;
                        }
                        l = 0;
                        while (l < this.themeNum) {
                            themeProb = themeProbSum != 0.0 ? ((1.0 - this.comThemeCoeffi) * this.arrThemeProb[m][l][termIndex] + this.comThemeCoeffi * this.arrCommonThemeProb[l][termIndex]) * this.arrDocView[i][m] * this.arrDocTheme[i][m][l] / themeProbSum : 0.0;
                            double commonThemeProb = (1.0 - this.comThemeCoeffi) * this.arrThemeProb[m][l][termIndex] + this.comThemeCoeffi * this.arrCommonThemeProb[l][termIndex];
                            commonThemeProb = commonThemeProb > 0.0 ? this.comThemeCoeffi * this.arrCommonThemeProb[l][termIndex] / commonThemeProb : 0.0;
                            termProb = (double)arrFreq[j] * themeProb;
                            double[] dArray = arrDocThemeSum[m];
                            int n = l;
                            dArray[n] = dArray[n] + termProb;
                            double[] dArray2 = arrTempThemeProb[m][l];
                            int n2 = termIndex;
                            dArray2[n2] = dArray2[n2] + (termProb *= 1.0 - themeBkgProb) * (1.0 - commonThemeProb);
                            double[] dArray3 = arrTempThemeCommonProb[l];
                            int n3 = termIndex;
                            dArray3[n3] = dArray3[n3] + termProb * commonThemeProb;
                            ++l;
                        }
                        ++m;
                    }
                    ++j;
                }
                m = 0;
                while (m < viewNum) {
                    docWeightSum = 0.0;
                    l = 0;
                    while (l < this.themeNum) {
                        docWeightSum += arrDocThemeSum[m][l];
                        ++l;
                    }
                    if (docWeightSum > 0.0) {
                        l = 0;
                        while (l < this.themeNum) {
                            this.arrDocTheme[i][m][l] = arrDocThemeSum[m][l] / docWeightSum;
                            ++l;
                        }
                    } else {
                        l = 0;
                        while (l < this.themeNum) {
                            this.arrDocTheme[i][m][l] = 0.0;
                            ++l;
                        }
                    }
                    ++m;
                }
                arrIndex = this.viewIndexReader.getTermIndexList(i);
                arrFreq = this.viewIndexReader.getTermFrequencyList(i);
                j = 0;
                while (j < arrIndex.length) {
                    termIndex = arrIndex[j];
                    themeProbSum = 0.0;
                    m = 0;
                    while (m < viewNum) {
                        themeProbSum += this.arrViewProb[m][termIndex] * this.arrDocView[m][i];
                        ++m;
                    }
                    double viewBkgProb = this.viewBkgModel.get(termIndex) / (themeProbSum * (1.0 - this.viewBkgCoeffi) + this.viewBkgModel.get(termIndex));
                    m = 0;
                    while (m < viewNum) {
                        themeProb = themeProbSum != 0.0 ? this.arrViewProb[m][termIndex] * this.arrDocView[i][m] / themeProbSum : 0.0;
                        termProb = (double)arrFreq[j] * themeProb;
                        int n = m;
                        arrDocViewSum[n] = arrDocViewSum[n] + termProb;
                        double[] dArray = arrTempViewProb[m];
                        int n4 = termIndex;
                        dArray[n4] = dArray[n4] + (termProb *= 1.0 - viewBkgProb);
                        ++m;
                    }
                    ++j;
                }
                docWeightSum = 0.0;
                m = 0;
                while (m < viewNum) {
                    docWeightSum += arrDocViewSum[m];
                    ++m;
                }
                if (docWeightSum > 0.0) {
                    m = 0;
                    while (m < viewNum) {
                        this.arrDocView[i][m] = arrDocViewSum[m] / docWeightSum;
                        ++m;
                    }
                } else {
                    m = 0;
                    while (m < viewNum) {
                        this.arrDocView[i][m] = 0.0;
                        ++m;
                    }
                }
                ++i;
            }
            m = 0;
            while (m < viewNum) {
                termProbSum = 0.0;
                i = 0;
                while (i < this.viewTermNum) {
                    termProbSum += arrTempViewProb[m][i];
                    ++i;
                }
                i = 0;
                while (i < this.viewTermNum) {
                    this.arrViewProb[m][i] = termProbSum != 0.0 ? arrTempViewProb[m][i] / termProbSum : 0.0;
                    ++i;
                }
                ++m;
            }
            l = 0;
            while (l < this.themeNum) {
                termProbSum = 0.0;
                i = 0;
                while (i < this.themeTermNum) {
                    termProbSum += arrTempThemeCommonProb[l][i];
                    ++i;
                }
                i = 0;
                while (i < this.themeTermNum) {
                    if (termProbSum != 0.0) {
                        this.arrCommonThemeProb[l][i] = arrTempThemeCommonProb[l][i] / termProbSum;
                    } else {
                        this.arrCommonThemeProb[1][i] = 0.0;
                    }
                    ++i;
                }
                ++l;
            }
            m = 0;
            while (m < viewNum) {
                l = 0;
                while (l < this.themeNum) {
                    termProbSum = 0.0;
                    i = 0;
                    while (i < this.themeTermNum) {
                        termProbSum += arrTempThemeProb[m][l][i];
                        ++i;
                    }
                    i = 0;
                    while (i < this.themeTermNum) {
                        if (termProbSum != 0.0) {
                            this.arrThemeProb[m][l][i] = arrTempThemeProb[m][l][i] / termProbSum;
                        } else {
                            this.arrThemeProb[m][1][i] = 0.0;
                        }
                        ++i;
                    }
                    ++l;
                }
                ++m;
            }
            ++k;
        }
        this.printStatus("");
        return true;
    }

    protected void initialize(int docNum, int viewTermNum, int viewNum, double[][] arrViewModel, double[][] arrDocView, int themeTermNum, int themeNum, double[][] arrThemeCommonModel, double[][][] arrThemeModel, double[][][] arrDocTheme) {
        int k;
        double docProb;
        int j;
        Random random = this.seed >= 0 ? new Random(this.seed) : new Random();
        double termProb = 1.0 / (double)viewTermNum;
        int i = 0;
        while (i < viewNum) {
            j = 0;
            while (j < viewTermNum) {
                arrViewModel[i][j] = termProb;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < docNum) {
            docProb = 0.0;
            j = 0;
            while (j < viewNum) {
                arrDocView[i][j] = random.nextDouble();
                docProb += arrDocView[i][j];
                ++j;
            }
            j = 0;
            while (j < viewNum) {
                arrDocView[i][j] = arrDocView[i][j] / docProb;
                ++j;
            }
            ++i;
        }
        termProb = 1.0 / (double)themeTermNum;
        j = 0;
        while (j < themeNum) {
            k = 0;
            while (k < themeTermNum) {
                arrThemeCommonModel[j][k] = termProb;
                ++k;
            }
            ++j;
        }
        i = 0;
        while (i < viewNum) {
            j = 0;
            while (j < themeNum) {
                k = 0;
                while (k < themeTermNum) {
                    arrThemeModel[i][j][k] = termProb;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < viewNum) {
            k = 0;
            while (k < docNum) {
                docProb = 0.0;
                j = 0;
                while (j < themeNum) {
                    arrDocTheme[k][i][j] = random.nextDouble();
                    docProb += arrDocTheme[k][i][j];
                    ++j;
                }
                j = 0;
                while (j < themeNum) {
                    arrDocTheme[k][i][j] = docProb != 0.0 ? arrDocTheme[k][i][j] / docProb : 0.0;
                    ++j;
                }
                ++k;
            }
            ++i;
        }
    }
}

