/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.topicmodel;

import dragon.ir.index.IndexReader;
import dragon.ir.topicmodel.AbstractTopicModel;
import dragon.matrix.vector.DoubleVector;
import java.util.Date;
import java.util.Random;

public class SimpleMixtureModel
extends AbstractTopicModel {
    protected DoubleVector bkgModel;
    protected double bkgCoefficient;

    public SimpleMixtureModel(IndexReader indexReader, double bkgCoefficient) {
        this(indexReader, null, bkgCoefficient);
    }

    public SimpleMixtureModel(IndexReader indexReader, DoubleVector bkgModel, double bkgCoefficient) {
        super(indexReader);
        bkgModel = bkgModel == null ? this.getBkgModel(indexReader) : bkgModel.copy();
        this.bkgModel = bkgModel;
        this.bkgCoefficient = bkgCoefficient;
        this.bkgModel.multiply(bkgCoefficient);
    }

    public boolean estimateModel(int topicNum) {
        return this.estimateModel(null, topicNum);
    }

    public boolean estimateModel(int[] arrDoc, int topicNum) {
        this.themeNum = topicNum;
        this.termNum = this.indexReader.getCollection().getTermNum();
        this.docNum = arrDoc == null ? this.indexReader.getCollection().getDocNum() : arrDoc.length;
        this.arrThemeTerm = new double[this.themeNum][this.termNum];
        double[][] arrTempProb = new double[this.themeNum][this.termNum];
        this.arrDocTheme = new double[this.docNum][this.themeNum];
        double[] arrDocWeightSum = new double[this.themeNum];
        this.initialize(this.termNum, this.themeNum, this.docNum, this.arrThemeTerm, this.arrDocTheme);
        this.printStatus("Estimating the coefficients of simple mixture model...");
        int k = 0;
        while (k < this.iterations) {
            int j;
            this.printStatus(new Date().toString() + " Iteration #" + (k + 1));
            int i = 0;
            while (i < this.themeNum) {
                j = 0;
                while (j < this.termNum) {
                    arrTempProb[i][j] = 0.0;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.docNum) {
                int[] arrFreq;
                int[] arrIndex;
                if (arrDoc == null) {
                    arrIndex = this.indexReader.getTermIndexList(i);
                    arrFreq = this.indexReader.getTermFrequencyList(i);
                } else {
                    arrIndex = this.indexReader.getTermIndexList(arrDoc[i]);
                    arrFreq = this.indexReader.getTermFrequencyList(arrDoc[i]);
                }
                int m = 0;
                while (m < this.themeNum) {
                    arrDocWeightSum[m] = 0.0;
                    ++m;
                }
                j = 0;
                while (j < arrIndex.length) {
                    int termIndex = arrIndex[j];
                    double themeProbSum = 0.0;
                    m = 0;
                    while (m < this.themeNum) {
                        themeProbSum += this.arrThemeTerm[m][termIndex] * this.arrDocTheme[i][m];
                        ++m;
                    }
                    double bkgProb = this.bkgModel.get(termIndex) / (themeProbSum * (1.0 - this.bkgCoefficient) + this.bkgModel.get(termIndex));
                    m = 0;
                    while (m < this.themeNum) {
                        double themeProb = themeProbSum != 0.0 ? this.arrThemeTerm[m][termIndex] * this.arrDocTheme[i][m] / themeProbSum : 0.0;
                        double termProb = (double)arrFreq[j] * themeProb;
                        int n = m;
                        arrDocWeightSum[n] = arrDocWeightSum[n] + termProb;
                        double[] dArray = arrTempProb[m];
                        int n2 = termIndex;
                        dArray[n2] = dArray[n2] + termProb * (1.0 - bkgProb);
                        ++m;
                    }
                    ++j;
                }
                double docWeightSum = 0.0;
                m = 0;
                while (m < this.themeNum) {
                    docWeightSum += arrDocWeightSum[m];
                    ++m;
                }
                if (docWeightSum > 0.0) {
                    m = 0;
                    while (m < this.themeNum) {
                        this.arrDocTheme[i][m] = arrDocWeightSum[m] / docWeightSum;
                        ++m;
                    }
                } else {
                    m = 0;
                    while (m < this.themeNum) {
                        this.arrDocTheme[i][m] = 0.0;
                        ++m;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.themeNum) {
                double termProbSum = 0.0;
                j = 0;
                while (j < this.termNum) {
                    termProbSum += arrTempProb[i][j];
                    ++j;
                }
                j = 0;
                while (j < this.termNum) {
                    this.arrThemeTerm[i][j] = arrTempProb[i][j] / termProbSum;
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        this.printStatus("");
        return true;
    }

    protected void initialize(int termNum, int themeNum, int docNum, double[][] arrModel, double[][] arrDocMembership) {
        int j;
        double termProb = 1.0 / (double)termNum;
        int i = 0;
        while (i < themeNum) {
            j = 0;
            while (j < termNum) {
                arrModel[i][j] = termProb;
                ++j;
            }
            ++i;
        }
        Random random = new Random(this.seed);
        i = 0;
        while (i < docNum) {
            double docProb = 0.0;
            j = 0;
            while (j < themeNum) {
                arrDocMembership[i][j] = random.nextDouble();
                docProb += arrDocMembership[i][j];
                ++j;
            }
            j = 0;
            while (j < themeNum) {
                arrDocMembership[i][j] = arrDocMembership[i][j] / docProb;
                ++j;
            }
            ++i;
        }
    }
}

