/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.summarize;

import dragon.nlp.Counter;
import dragon.nlp.Document;
import dragon.nlp.DocumentParser;
import dragon.nlp.Paragraph;
import dragon.nlp.Sentence;
import dragon.nlp.SimpleElementList;
import dragon.nlp.SimplePair;
import dragon.nlp.Token;
import dragon.nlp.compare.IndexComparator;
import dragon.nlp.extract.BasicConceptFilter;
import dragon.nlp.extract.BasicTokenExtractor;
import dragon.nlp.extract.TokenExtractor;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.PorterStemmer;
import dragon.util.EnvVariable;
import dragon.util.MathUtil;
import dragon.util.SortedArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ROUGE {
    public static final int ROUGE_N = 1;
    public static final int ROUGE_L = 2;
    public static final int ROUGE_W = 3;
    public static final int ROUGE_S = 4;
    public static final int ROUGE_SU = 5;
    public static final int MULTIPLE_MAX = 1;
    public static final int MULTIPLE_MIN = 2;
    public static final int MULTIPLE_AVG = 3;
    private static final String stopwordFile = "nlpdata/rouge/rouge.stopword";
    private TokenExtractor tokenExtractor = new BasicTokenExtractor(null);
    private double beta = 1.0;
    private double[][] evaStat;
    private int metric = 1;
    private int multipleMode;
    private int gram = 2;
    private int maxSkip;
    private boolean caseSensitive = false;

    public void setBeta(double beta) {
        if (beta > 0.0) {
            this.beta = beta;
        }
    }

    public double getBeta() {
        return this.beta;
    }

    public void setLemmatiser(Lemmatiser lemmatiser) {
        this.tokenExtractor.setLemmatiser(lemmatiser);
    }

    public Lemmatiser getLemmatiser() {
        return this.tokenExtractor.getLemmatiser();
    }

    public void setLemmatiserOption(boolean option) {
        if (option) {
            this.tokenExtractor.setLemmatiser(new PorterStemmer());
        } else {
            this.tokenExtractor.setLemmatiser(null);
        }
    }

    public boolean getLemmatiserOption() {
        return this.tokenExtractor.getLemmatiser() != null;
    }

    public void setMultipleReferenceMode(int mode) {
        this.multipleMode = mode;
    }

    public void setStopwordOption(boolean option) {
        if (option) {
            this.tokenExtractor.setConceptFilter(new BasicConceptFilter(EnvVariable.getDragonHome() + "/" + stopwordFile));
        } else {
            this.tokenExtractor.setFilteringOption(false);
        }
    }

    public boolean getStopwordOption() {
        return this.tokenExtractor.getFilteringOption();
    }

    public void setStopwordFile(String stopwordFile) {
        this.tokenExtractor.setConceptFilter(new BasicConceptFilter(stopwordFile));
    }

    public void setCaseOption(boolean sensitive) {
        this.caseSensitive = sensitive;
    }

    public boolean getCaseOption() {
        return this.caseSensitive;
    }

    public void useRougeN(int gram) {
        this.gram = gram;
        this.metric = 1;
    }

    public int getGram() {
        return this.gram;
    }

    public void useRougeS() {
        this.maxSkip = Integer.MAX_VALUE;
        this.metric = 4;
    }

    public void useRougeS(int maxSkip) {
        this.maxSkip = maxSkip;
        this.metric = 4;
    }

    public double getPrecision() {
        return this.getEvaResult(1);
    }

    public double getRecall() {
        return this.getEvaResult(0);
    }

    public double getFScore() {
        return this.getEvaResult(2);
    }

    private double getEvaResult(int dimension) {
        double[] results = new double[this.evaStat.length];
        int i = 0;
        while (i < results.length) {
            results[i] = this.evaStat[i][dimension];
            ++i;
        }
        if (this.multipleMode == 1) {
            return MathUtil.max(results);
        }
        if (this.multipleMode == 3) {
            return MathUtil.average(results);
        }
        if (this.multipleMode == 2) {
            return MathUtil.min(results);
        }
        return -1.0;
    }

    public synchronized boolean evaluate(String testSummary, String[] refSummaries) {
        boolean ret = true;
        if (this.metric == 1) {
            this.computeRougeN(testSummary, refSummaries);
        } else if (this.metric == 4) {
            this.computeRougeS(testSummary, refSummaries);
        } else if (this.metric == 2) {
            this.computeRougeL(testSummary, refSummaries);
        } else if (this.metric == 5) {
            this.computeRougeSU(testSummary, refSummaries);
        } else {
            ret = false;
        }
        return ret;
    }

    public void printResult() {
        int k = 0;
        while (k < 50) {
            System.out.print("-");
            ++k;
        }
        System.out.println();
        int j = 0;
        while (j < this.evaStat.length) {
            System.out.println("ReferenceModel: " + (j + 1));
            System.out.println("Average_R: " + this.evaStat[j][0]);
            System.out.println("Average_P: " + this.evaStat[j][1]);
            System.out.println("Average_F: " + this.evaStat[j][2]);
            System.out.println();
            ++j;
        }
        k = 0;
        while (k < 50) {
            System.out.print("-");
            ++k;
        }
        System.out.println();
    }

    private void computeRougeN(String testSummary, String[] refSummaries) {
        ArrayList testList = this.tokenize(testSummary);
        this.evaStat = new double[refSummaries.length][3];
        HashMap testHash = this.computeNgrams(testList, this.gram);
        int test2 = testList.size() - this.gram + 1;
        int j = 0;
        while (j < refSummaries.length) {
            ArrayList referenceList = this.tokenize(refSummaries[j]);
            HashMap refHash = this.computeNgrams(referenceList, this.gram);
            int match = this.matchNgrams(testHash, refHash);
            int reference = referenceList.size() - this.gram + 1;
            this.evaStat[j][0] = reference <= 0 ? 0.0 : (double)match / (double)reference;
            this.evaStat[j][1] = test2 <= 0 ? 0.0 : (double)match / (double)test2;
            this.evaStat[j][2] = this.computeFScore(this.evaStat[j][1], this.evaStat[j][0]);
            ++j;
        }
    }

    private void computeRougeS(String testSummary, String[] refSummaries) {
        SimpleElementList keyList = new SimpleElementList();
        ArrayList testList = this.index(this.tokenize(testSummary), keyList);
        int test2 = this.countSkipBigram(testList.size(), this.maxSkip);
        this.evaStat = new double[refSummaries.length][3];
        int j = 0;
        while (j < refSummaries.length) {
            ArrayList referenceList = this.index(this.tokenize(refSummaries[j]), keyList);
            HashSet hashGrams = this.computeSkipBigram(referenceList, this.maxSkip);
            int match = this.matchSkipBigram(testList, this.maxSkip, hashGrams);
            int reference = this.countSkipBigram(testList.size(), this.maxSkip);
            this.evaStat[j][0] = reference <= 0 ? 0.0 : (double)match / (double)reference;
            this.evaStat[j][1] = test2 <= 0 ? 0.0 : (double)match / (double)test2;
            this.evaStat[j][2] = this.computeFScore(this.evaStat[j][1], this.evaStat[j][0]);
            ++j;
        }
    }

    private void computeRougeSU(String testSummary, String[] refSummaries) {
        SimpleElementList keyList = new SimpleElementList();
        ArrayList testList = this.index(this.tokenize(testSummary), keyList);
        int test2 = this.countSkipBigram(testList.size(), this.maxSkip) + testList.size();
        this.evaStat = new double[refSummaries.length][3];
        int j = 0;
        while (j < refSummaries.length) {
            ArrayList referenceList = this.index(this.tokenize(refSummaries[j]), keyList);
            HashSet hashGrams = this.computeSkipBigram(referenceList, this.maxSkip);
            int match = this.matchSkipBigram(testList, this.maxSkip, hashGrams);
            int reference = this.countSkipBigram(testList.size(), this.maxSkip) + referenceList.size();
            this.evaStat[j][0] = reference <= 0 ? 0.0 : (double)match / (double)reference;
            this.evaStat[j][1] = test2 <= 0 ? 0.0 : (double)match / (double)test2;
            this.evaStat[j][2] = this.computeFScore(this.evaStat[j][1], this.evaStat[j][0]);
            ++j;
        }
    }

    private void computeRougeL(String testSummary, String[] refSummaries) {
        DocumentParser parser = this.tokenExtractor.getDocumentParser();
        Document testDoc = parser.parse(testSummary);
        int test2 = this.tokenize(testDoc).size();
        this.evaStat = new double[refSummaries.length][3];
        int j = 0;
        while (j < refSummaries.length) {
            int match = 0;
            Document refDoc = parser.parse(refSummaries[j]);
            Paragraph curPara = refDoc.getFirstParagraph();
            while (curPara != null) {
                Sentence curSent = curPara.getFirstSentence();
                while (curSent != null) {
                    match += this.matchLCS(curSent, testDoc);
                    curSent = curSent.next;
                }
                curPara = curPara.next;
            }
            int reference = this.tokenize(refDoc).size();
            this.evaStat[j][0] = reference <= 0 ? 0.0 : (double)match / (double)reference;
            this.evaStat[j][1] = test2 <= 0 ? 0.0 : (double)match / (double)test2;
            this.evaStat[j][2] = this.computeFScore(this.evaStat[j][1], this.evaStat[j][0]);
            ++j;
        }
    }

    private HashMap computeNgrams(ArrayList wordList, int nGram) {
        int start = 0;
        int end = nGram;
        HashMap<String, Counter> hashGrams = new HashMap<String, Counter>();
        while (end <= wordList.size()) {
            String gramStr = this.getNgram(wordList, start, end);
            Counter counter = (Counter)hashGrams.get(gramStr);
            if (counter != null) {
                counter.addCount(1);
            } else {
                hashGrams.put(gramStr, new Counter(1));
            }
            ++start;
            ++end;
        }
        return hashGrams;
    }

    private int matchNgrams(HashMap testHash, HashMap refMap) {
        int count2 = 0;
        Iterator iterator2 = testHash.keySet().iterator();
        while (iterator2.hasNext()) {
            String gramStr = (String)iterator2.next();
            Counter testCounter = (Counter)testHash.get(gramStr);
            Counter refCounter = (Counter)refMap.get(gramStr);
            if (refCounter == null) continue;
            count2 += Math.min(testCounter.getCount(), refCounter.getCount());
        }
        return count2;
    }

    private String getNgram(ArrayList wordList, int start, int end) {
        String gramStr = null;
        int i = start;
        while (i < end) {
            gramStr = i == 0 ? ((Token)wordList.get(i)).getName() : gramStr + "\t" + ((Token)wordList.get(i)).getName();
            ++i;
        }
        return gramStr;
    }

    private HashSet computeSkipBigram(ArrayList list2, int maxSkip) {
        HashSet<SimplePair> hash = new HashSet<SimplePair>();
        int start = 0;
        int end = Math.min(start + maxSkip + 1, list2.size() - 1);
        while (start < end) {
            int first = ((Token)list2.get(start)).getIndex();
            int i = start + 1;
            while (i <= end) {
                int second = ((Token)list2.get(i)).getIndex();
                hash.add(new SimplePair(hash.size(), first, second));
                ++i;
            }
            end = Math.min(++start + maxSkip + 1, list2.size() - 1);
        }
        return hash;
    }

    private int matchSkipBigram(ArrayList list2, int maxSkip, HashSet reference) {
        int start = 0;
        int count2 = 0;
        int end = Math.min(start + maxSkip + 1, list2.size() - 1);
        while (start < end) {
            int first = ((Token)list2.get(start)).getIndex();
            int i = start + 1;
            while (i <= end) {
                int second = ((Token)list2.get(i)).getIndex();
                if (reference.contains(new SimplePair(-1, first, second))) {
                    ++count2;
                }
                ++i;
            }
            end = Math.min(++start + maxSkip + 1, list2.size() - 1);
        }
        return count2;
    }

    private int countSkipBigram(int textLength, int maxSkip) {
        int start = 0;
        int count2 = 0;
        int end = Math.min(start + maxSkip + 1, textLength - 1);
        while (start < end) {
            count2 += end - start;
            end = Math.min(++start + maxSkip + 1, textLength - 1);
        }
        return count2;
    }

    private int matchLCS(Sentence refSent, Document testDoc) {
        SimpleElementList keyList = new SimpleElementList();
        SortedArray list2 = new SortedArray(new IndexComparator());
        ArrayList refList = this.index(this.tokenize(refSent), keyList);
        Paragraph curPara = testDoc.getFirstParagraph();
        while (curPara != null) {
            Sentence curSent = curPara.getFirstSentence();
            while (curSent != null) {
                ArrayList testList = this.index(this.tokenize(curSent), keyList);
                ArrayList lcsList = this.computeLCS(refList, testList);
                int i = 0;
                while (i < lcsList.size()) {
                    list2.add(lcsList.get(i));
                    ++i;
                }
                curSent = curSent.next;
            }
            curPara = curPara.next;
        }
        return list2.size();
    }

    private ArrayList computeLCS(ArrayList first, ArrayList second) {
        return null;
    }

    private ArrayList index(ArrayList list2, SimpleElementList keyList) {
        int i = 0;
        while (i < list2.size()) {
            Token curToken = (Token)list2.get(i);
            curToken.setIndex(keyList.add(curToken.getValue()));
            ++i;
        }
        return list2;
    }

    private ArrayList tokenize(String doc) {
        ArrayList list2 = this.tokenExtractor.extractFromDoc(doc);
        if (!this.caseSensitive) {
            int i = 0;
            while (i < list2.size()) {
                Token curToken = (Token)list2.get(i);
                curToken.setValue(curToken.getValue().toLowerCase());
                ++i;
            }
        }
        return list2;
    }

    private ArrayList tokenize(Document doc) {
        ArrayList list2 = this.tokenExtractor.extractFromDoc(doc);
        if (!this.caseSensitive) {
            int i = 0;
            while (i < list2.size()) {
                Token curToken = (Token)list2.get(i);
                curToken.setValue(curToken.getValue().toLowerCase());
                ++i;
            }
        }
        return list2;
    }

    private ArrayList tokenize(Sentence sent) {
        ArrayList list2 = this.tokenExtractor.extractFromSentence(sent);
        if (!this.caseSensitive) {
            int i = 0;
            while (i < list2.size()) {
                Token curToken = (Token)list2.get(i);
                curToken.setValue(curToken.getValue().toLowerCase());
                ++i;
            }
        }
        return list2;
    }

    private double computeFScore(double precision, double recall2) {
        if (precision == 0.0 || recall2 == 0.0) {
            return 0.0;
        }
        if (this.beta == Double.MAX_VALUE) {
            return recall2;
        }
        return (1.0 + this.beta * this.beta) * precision * recall2 / (recall2 + this.beta * this.beta * precision);
    }
}

