/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.summarize;

import dragon.ir.clustering.docdistance.CosineDocDistance;
import dragon.ir.clustering.docdistance.DocDistance;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.index.sentence.OnlineSentenceIndexReader;
import dragon.ir.index.sentence.OnlineSentenceIndexer;
import dragon.ir.kngbase.DocRepresentation;
import dragon.ir.summarize.AbstractSentenceSum;
import dragon.ir.summarize.GenericMultiDocSummarizer;
import dragon.matrix.DoubleDenseMatrix;
import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.matrix.vector.DoubleVector;
import dragon.matrix.vector.PowerMethod;
import dragon.onlinedb.CollectionReader;
import java.util.ArrayList;

public class LexRankSummarizer
extends AbstractSentenceSum
implements GenericMultiDocSummarizer {
    protected OnlineSentenceIndexReader indexReader;
    protected OnlineSentenceIndexer indexer;
    protected CollectionReader collectionReader;
    protected DocDistance distanceMetric;
    protected PowerMethod powerMethod;
    protected double threshold;
    protected boolean useContinuousValue;
    protected boolean useTFIDF;

    public LexRankSummarizer(OnlineSentenceIndexer indexer) {
        this(indexer, true);
    }

    public LexRankSummarizer(OnlineSentenceIndexer indexer, boolean useTFIDF) {
        this.indexer = indexer;
        this.threshold = 0.1;
        this.useContinuousValue = true;
        this.useTFIDF = useTFIDF;
        this.powerMethod = new PowerMethod(1.0E-4, 0.15);
        this.powerMethod.setMessageOption(false);
        this.powerMethod.setMaxIteration(50);
    }

    public void setSimilarityThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setContinuousScoreOpiton(boolean option) {
        this.useContinuousValue = option;
    }

    public String summarize(CollectionReader collectionReader, int maxLength) {
        this.collectionReader = collectionReader;
        this.indexReader = new OnlineSentenceIndexReader(this.indexer, collectionReader);
        this.indexReader.initialize();
        ArrayList sentSet = this.getSentenceSet(this.indexReader);
        DoubleVector vector = this.powerMethod.getEigenVector(this.buildWeightMatrix(sentSet));
        String summary = this.buildSummary(this.indexReader, sentSet, maxLength, vector);
        this.indexReader.close();
        this.distanceMetric = null;
        return summary;
    }

    protected DoubleDenseMatrix buildWeightMatrix(ArrayList docSet) {
        DoubleFlatDenseMatrix matrix = new DoubleFlatDenseMatrix(docSet.size(), docSet.size());
        int i = 0;
        while (i < docSet.size()) {
            matrix.setDouble(i, i, 1.0);
            IRDoc first = (IRDoc)docSet.get(i);
            int j = i + 1;
            while (j < docSet.size()) {
                IRDoc second = (IRDoc)docSet.get(j);
                double similarity = this.computeSimilarity(first, second);
                if (!this.useContinuousValue) {
                    similarity = similarity <= this.threshold ? 0.0 : 1.0;
                }
                matrix.setDouble(i, j, similarity);
                matrix.setDouble(j, i, similarity);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    protected double computeSimilarity(IRDoc firstSent, IRDoc secondSent) {
        if (this.distanceMetric == null) {
            if (this.useTFIDF) {
                DocRepresentation docRepresentation = new DocRepresentation(this.indexReader);
                docRepresentation.setMessageOption(false);
                this.distanceMetric = new CosineDocDistance(docRepresentation.genTFIDFMatrix());
            } else {
                this.distanceMetric = new CosineDocDistance(this.indexReader.getDocTermMatrix());
            }
        }
        return 1.0 - this.distanceMetric.getDistance(firstSent, secondSent);
    }

    protected ArrayList getSentenceSet(IndexReader indexReader) {
        int docNum = indexReader.getCollection().getDocNum();
        ArrayList<IRDoc> list2 = new ArrayList<IRDoc>(docNum);
        int i = 0;
        while (i < docNum) {
            list2.add(indexReader.getDoc(i));
            ++i;
        }
        return list2;
    }
}

