/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.summarize;

import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.DocClusterSet;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.summarize.TextUnit;
import dragon.ir.summarize.TopicSummary;
import dragon.matrix.vector.DoubleVector;
import dragon.nlp.compare.IndexComparator;
import dragon.nlp.compare.WeightComparator;
import dragon.onlinedb.Article;
import dragon.util.SortedArray;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractSentenceSum {
    protected String buildSummary(IndexReader indexReader, ArrayList sentSet, int summaryLength, DoubleVector weightVector) {
        IRDoc curDoc;
        int curLength = 0;
        TopicSummary summary = new TopicSummary(3);
        ArrayList<IRDoc> list2 = new ArrayList<IRDoc>(sentSet.size());
        int i = 0;
        while (i < sentSet.size()) {
            curDoc = (IRDoc)sentSet.get(i);
            curDoc.setWeight(weightVector.get(i));
            list2.add(curDoc);
            ++i;
        }
        Collections.sort(list2, new WeightComparator(true));
        i = 0;
        while (i < list2.size() && curLength < summaryLength) {
            String curSentence;
            curDoc = (IRDoc)list2.get(i);
            Article article = indexReader.getOriginalDoc(curDoc.getIndex());
            if (article != null && (curSentence = article.getTitle()) != null && !summary.contains(new TextUnit(curSentence)) && curLength < summaryLength) {
                summary.addText(new TextUnit(curSentence, curDoc.getIndex(), curDoc.getWeight()));
                curLength += curSentence.length();
            }
            ++i;
        }
        summary.sortByWegiht();
        if (summary.size() == 0) {
            return null;
        }
        StringBuffer autoSum = new StringBuffer(summary.getTextUnit(0).getText());
        i = 1;
        while (i < summary.size()) {
            autoSum.append("\n");
            autoSum.append(summary.getTextUnit(i).getText());
            ++i;
        }
        if (autoSum.length() <= summaryLength) {
            return autoSum.toString();
        }
        return autoSum.substring(0, summaryLength);
    }

    protected String buildSummary(IndexReader indexReader, ArrayList sentSet, int summaryLength, DoubleVector weightVector, DocClusterSet clusters) {
        String curSentence;
        Article article;
        IRDoc curDoc;
        SortedArray list2 = new SortedArray(sentSet.size(), new IndexComparator());
        int i = 0;
        while (i < sentSet.size()) {
            curDoc = (IRDoc)sentSet.get(i);
            curDoc.setWeight(weightVector.get(i));
            list2.add(curDoc);
            ++i;
        }
        i = 0;
        while (i < clusters.getClusterNum()) {
            DocCluster curCluster = clusters.getDocCluster(i);
            int j = 0;
            while (j < curCluster.getDocNum()) {
                curDoc = curCluster.getDoc(j);
                int pos = list2.binarySearch(curDoc);
                if (pos >= 0) {
                    curDoc = (IRDoc)list2.get(pos);
                    curDoc.setCategory(i);
                }
                ++j;
            }
            ++i;
        }
        list2.setComparator(new WeightComparator(true));
        boolean[] usedDoc = new boolean[list2.size()];
        boolean[] usedCluster = new boolean[clusters.getClusterNum()];
        int curLength = 0;
        TopicSummary summary = new TopicSummary(3);
        i = 0;
        while (i < list2.size() && curLength < summaryLength) {
            curDoc = (IRDoc)list2.get(i);
            if (!usedCluster[curDoc.getCategory()] && (article = indexReader.getOriginalDoc(curDoc.getIndex())) != null && (curSentence = article.getTitle()) != null && !summary.contains(new TextUnit(curSentence)) && curLength < summaryLength) {
                summary.addText(new TextUnit(curSentence, curDoc.getIndex(), curDoc.getWeight()));
                curLength += curSentence.length();
                usedCluster[curDoc.getCategory()] = true;
                usedDoc[i] = true;
            }
            ++i;
        }
        i = 0;
        while (i < list2.size() && curLength < summaryLength) {
            if (!usedDoc[i] && (article = indexReader.getOriginalDoc((curDoc = (IRDoc)list2.get(i)).getIndex())) != null && (curSentence = article.getTitle()) != null && !summary.contains(new TextUnit(curSentence)) && curLength < summaryLength) {
                summary.addText(new TextUnit(curSentence, curDoc.getIndex(), curDoc.getWeight()));
                curLength += curSentence.length();
                usedDoc[i] = true;
            }
            ++i;
        }
        summary.sortByWegiht();
        if (summary.size() == 0) {
            return null;
        }
        StringBuffer autoSum = new StringBuffer(summary.getTextUnit(0).getText());
        i = 1;
        while (i < summary.size()) {
            autoSum.append("\n");
            autoSum.append(summary.getTextUnit(i).getText());
            ++i;
        }
        if (autoSum.length() <= summaryLength) {
            return autoSum.toString();
        }
        return autoSum.substring(0, summaryLength);
    }
}

