/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.smooth;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDoc;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.smooth.AbstractSmoother;
import dragon.ir.search.smooth.Smoother;

public class TwoStageSmoother
extends AbstractSmoother
implements Smoother {
    private double bkgCoefficient;
    private double dirichletCoefficient;
    private int docTermCount;
    private long collectionTermCount;
    private double docCollectionProb;
    private double queryBackgroundProb;

    public TwoStageSmoother(IRCollection collection, double bkgCoefficient, double dirichletCoefficient) {
        this.collectionTermCount = collection.getTermCount();
        this.bkgCoefficient = bkgCoefficient;
        this.dirichletCoefficient = dirichletCoefficient;
        this.useLog = true;
        this.docFirstOptimal = true;
        this.querytermFirstOptimal = true;
    }

    public boolean setParameters(double[] params) {
        if (params != null && params.length >= 2) {
            this.bkgCoefficient = params[0];
            this.dirichletCoefficient = params[1];
            return true;
        }
        return false;
    }

    public void setQueryTerm(SimpleTermPredicate queryTerm) {
        this.queryWeight = queryTerm.getWeight();
        this.docCollectionProb = this.dirichletCoefficient * (double)queryTerm.getFrequency() / (double)this.collectionTermCount;
        this.queryBackgroundProb = this.bkgCoefficient * (double)queryTerm.getFrequency() / (double)this.collectionTermCount;
    }

    public void setDoc(IRDoc doc) {
        this.docTermCount = doc.getTermCount();
    }

    protected double computeSmoothedProb(int termFreq) {
        return this.queryWeight * this.getProb((1.0 - this.bkgCoefficient) * ((double)termFreq + this.docCollectionProb) / ((double)this.docTermCount + this.dirichletCoefficient) + this.queryBackgroundProb);
    }
}

