/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.smooth;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDoc;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.smooth.AbstractSmoother;
import dragon.ir.search.smooth.Smoother;

public class JMSmoother
extends AbstractSmoother
implements Smoother {
    private double bkgCoefficient;
    private int docTermCount;
    private long collectionTermCount;
    private double collectionProb;

    public JMSmoother(IRCollection collection, double bkgCoefficient) {
        this.collectionTermCount = collection.getTermCount();
        this.bkgCoefficient = bkgCoefficient;
        this.useLog = true;
        this.docFirstOptimal = true;
        this.querytermFirstOptimal = true;
    }

    public boolean setParameters(double[] params) {
        if (params != null && params.length >= 1) {
            this.bkgCoefficient = params[0];
            return true;
        }
        return false;
    }

    public void setQueryTerm(SimpleTermPredicate queryTerm) {
        this.queryWeight = queryTerm.getWeight();
        this.collectionProb = this.bkgCoefficient * (double)queryTerm.getFrequency() / (double)this.collectionTermCount;
    }

    public void setDoc(IRDoc doc) {
        this.docTermCount = doc.getTermCount();
        if (this.docTermCount <= 0) {
            this.docTermCount = 1;
        }
    }

    protected double computeSmoothedProb(int termFreq) {
        return this.queryWeight * this.getProb((double)termFreq * (1.0 - this.bkgCoefficient) / (double)this.docTermCount + this.collectionProb);
    }
}

