/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.smooth;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDoc;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.smooth.AbstractSmoother;

public class DirichletSmoother
extends AbstractSmoother {
    private long collectionTermCount;
    private double dirichletCoeffi;
    private double collectionProb;
    private int docTermCount;

    public DirichletSmoother(IRCollection collection, double dirichletCoeffi) {
        this.collectionTermCount = collection.getTermCount();
        this.dirichletCoeffi = dirichletCoeffi;
        this.useLog = true;
        this.docFirstOptimal = true;
        this.querytermFirstOptimal = true;
    }

    public boolean setParameters(double[] params) {
        if (params != null && params.length >= 1) {
            this.dirichletCoeffi = params[0];
            return true;
        }
        return false;
    }

    public void setQueryTerm(SimpleTermPredicate queryTerm) {
        this.queryWeight = queryTerm.getWeight();
        this.collectionProb = this.dirichletCoeffi * (double)queryTerm.getFrequency() / (double)this.collectionTermCount;
    }

    public void setDoc(IRDoc doc) {
        this.docTermCount = doc.getTermCount();
    }

    protected double computeSmoothedProb(int termFreq) {
        return this.queryWeight * this.getProb(((double)termFreq + this.collectionProb) / ((double)this.docTermCount + this.dirichletCoeffi));
    }
}

