/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.feedback;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.Searcher;
import dragon.ir.search.feedback.AbstractFeedback;
import dragon.matrix.DoubleSparseMatrix;
import dragon.nlp.Token;
import dragon.nlp.compare.IndexComparator;
import dragon.nlp.compare.WeightComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class RelationTransFeedback
extends AbstractFeedback {
    DoubleSparseMatrix transMatrix;
    private int expandTermNum;
    private double bkgCoeffi;
    private boolean selfTranslation;
    private boolean generativeModel;

    public RelationTransFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.transMatrix = null;
        this.selfTranslation = true;
        this.generativeModel = false;
    }

    public RelationTransFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi, DoubleSparseMatrix transMatrix) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.transMatrix = transMatrix;
        this.selfTranslation = false;
        this.generativeModel = false;
    }

    public RelationTransFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi, double bkgCoeffi) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.bkgCoeffi = bkgCoeffi;
        this.transMatrix = null;
        this.selfTranslation = true;
        this.generativeModel = true;
    }

    public RelationTransFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi, double bkgCoeffi, DoubleSparseMatrix transMatrix) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.bkgCoeffi = bkgCoeffi;
        this.transMatrix = transMatrix;
        this.selfTranslation = false;
        this.generativeModel = true;
    }

    protected ArrayList estimateNewQueryModel(IRQuery oldQuery) {
        int docNum;
        this.searcher.search(oldQuery);
        int n = docNum = this.feedbackDocNum < this.searcher.getRetrievedDocNum() ? this.feedbackDocNum : this.searcher.getRetrievedDocNum();
        if (docNum == 0) {
            return null;
        }
        ArrayList relationList = this.generativeModel ? this.generativeModel(docNum) : this.associationModel(docNum, oldQuery);
        SortedArray termList = this.translate(relationList);
        int predicateNum = oldQuery.getChildNum() + this.expandTermNum < termList.size() ? oldQuery.getChildNum() + this.expandTermNum : termList.size();
        ArrayList<SimpleTermPredicate> newPredicateList = new ArrayList<SimpleTermPredicate>(predicateNum);
        double weightSum = 0.0;
        int i = 0;
        while (i < predicateNum) {
            weightSum += ((Token)termList.get(i)).getWeight();
            ++i;
        }
        i = 0;
        while (i < predicateNum) {
            Token curToken = (Token)termList.get(i);
            SimpleTermPredicate curPredicate = this.buildSimpleTermPredicate(curToken.getIndex(), curToken.getWeight() / weightSum);
            newPredicateList.add(curPredicate);
            ++i;
        }
        return newPredicateList;
    }

    private ArrayList associationModel(int docNum, IRQuery oldQuery) {
        Token curToken;
        IndexReader indexReader = this.searcher.getIndexReader();
        SortedArray relationList = new SortedArray(new IndexComparator());
        SortedArray oldTermList = new SortedArray();
        int i = 0;
        while (i < oldQuery.getChildNum()) {
            SimpleTermPredicate curPredicate = (SimpleTermPredicate)oldQuery.getChild(i);
            if (curPredicate.getDocFrequency() > 0) {
                oldTermList.add(new Integer(curPredicate.getIndex()));
            }
            ++i;
        }
        double weightSum = 0.0;
        i = 0;
        while (i < docNum) {
            IRDoc curDoc = this.searcher.getIRDoc(i);
            int[] arrRelationIndex = indexReader.getRelationIndexList(curDoc.getIndex());
            int[] arrRelationFreq = indexReader.getRelationFrequencyList(curDoc.getIndex());
            int j = 0;
            while (j < arrRelationIndex.length) {
                IRRelation curRelation = indexReader.getIRRelation(arrRelationIndex[j]);
                if (oldTermList.contains(new Integer(curRelation.getFirstTerm())) || oldTermList.contains(new Integer(curRelation.getSecondTerm()))) {
                    curToken = new Token(null);
                    curToken.setWeight(arrRelationFreq[j]);
                    curToken.setIndex(arrRelationIndex[j]);
                    if (!relationList.add(curToken)) {
                        Token oldToken = (Token)relationList.get(relationList.insertedPos());
                        oldToken.setWeight(oldToken.getWeight() + curToken.getWeight());
                    }
                    weightSum += curToken.getWeight();
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < relationList.size()) {
            curToken = (Token)relationList.get(i);
            curToken.setWeight(curToken.getWeight() / weightSum);
            ++i;
        }
        relationList.setComparator(new WeightComparator(true));
        return relationList;
    }

    private ArrayList generativeModel(int docNum) {
        Token curToken;
        int j;
        IndexReader indexReader = this.searcher.getIndexReader();
        SortedArray relationList = new SortedArray(new IndexComparator());
        int i = 0;
        while (i < docNum) {
            IRDoc curDoc = this.searcher.getIRDoc(i);
            int[] arrIndex = indexReader.getRelationIndexList(curDoc.getIndex());
            int[] arrFreq = indexReader.getRelationFrequencyList(curDoc.getIndex());
            j = 0;
            while (j < arrIndex.length) {
                curToken = new Token(null);
                curToken.setIndex(arrIndex[j]);
                curToken.setFrequency(arrFreq[j]);
                if (!relationList.add(curToken)) {
                    ((Token)relationList.get(relationList.insertedPos())).addFrequency(curToken.getFrequency());
                }
                ++j;
            }
            ++i;
        }
        int iterationNum = 15;
        double[] arrProb = new double[relationList.size()];
        double[] arrCollectionProb = new double[relationList.size()];
        double collectionRelationCount = indexReader.getCollection().getRelationCount();
        i = 0;
        while (i < relationList.size()) {
            curToken = (Token)relationList.get(i);
            curToken.setWeight(1.0 / (double)relationList.size());
            arrCollectionProb[i] = this.bkgCoeffi * (double)indexReader.getIRRelation(curToken.getIndex()).getFrequency() / collectionRelationCount;
            ++i;
        }
        i = 0;
        while (i < iterationNum) {
            double weightSum = 0.0;
            j = 0;
            while (j < relationList.size()) {
                curToken = (Token)relationList.get(j);
                arrProb[j] = (1.0 - this.bkgCoeffi) * curToken.getWeight() / ((1.0 - this.bkgCoeffi) * curToken.getWeight() + arrCollectionProb[j]) * (double)curToken.getFrequency();
                weightSum += arrProb[j];
                ++j;
            }
            j = 0;
            while (j < relationList.size()) {
                ((Token)relationList.get(j)).setWeight(arrProb[j] / weightSum);
                ++j;
            }
            ++i;
        }
        relationList.setComparator(new WeightComparator(true));
        return relationList;
    }

    private SortedArray translate(ArrayList relationList) {
        Token curToken;
        IndexReader reader = this.searcher.getIndexReader();
        double[] arrWeight = new double[reader.getCollection().getTermNum()];
        int i = 0;
        while (i < arrWeight.length) {
            arrWeight[i] = 0.0;
            ++i;
        }
        int relationNum = this.selfTranslation ? relationList.size() : (100 < relationList.size() ? 100 : relationList.size());
        i = 0;
        while (i < relationNum) {
            curToken = (Token)relationList.get(i);
            if (this.selfTranslation) {
                IRRelation curRelation = reader.getIRRelation(curToken.getIndex());
                int n = curRelation.getFirstTerm();
                arrWeight[n] = arrWeight[n] + curToken.getWeight();
                int n2 = curRelation.getSecondTerm();
                arrWeight[n2] = arrWeight[n2] + curToken.getWeight();
            } else {
                int[] arrIndex = this.transMatrix.getNonZeroColumnsInRow(curToken.getIndex());
                double[] arrTransProb = this.transMatrix.getNonZeroDoubleScoresInRow(curToken.getIndex());
                if (arrIndex != null) {
                    int j = 0;
                    while (j < arrIndex.length) {
                        int n = arrIndex[j];
                        arrWeight[n] = arrWeight[n] + curToken.getWeight() * arrTransProb[j];
                        ++j;
                    }
                }
            }
            ++i;
        }
        SortedArray termList = new SortedArray(new WeightComparator(true));
        i = 0;
        while (i < arrWeight.length) {
            if (arrWeight[i] > 0.0) {
                curToken = new Token(null);
                curToken.setWeight(arrWeight[i]);
                curToken.setIndex(i);
                termList.add(curToken);
            }
            ++i;
        }
        return termList;
    }
}

