/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.expand;

import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.kngbase.HALSpace;
import dragon.ir.query.IRQuery;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.expand.AbstractQE;
import dragon.ir.search.expand.QueryExpansion;
import dragon.matrix.DoubleRow;
import dragon.matrix.DoubleSparseMatrix;
import dragon.nlp.SimpleElementList;
import dragon.nlp.Token;
import dragon.nlp.compare.WeightComparator;
import java.util.ArrayList;
import java.util.Collections;

public class InformationFlowQE
extends AbstractQE
implements QueryExpansion {
    private DoubleSparseMatrix halMatrix;
    private SimpleElementList halTermList;
    private IndexReader indexReader;
    private int expandTerm;
    private double expandCoeffi;
    private double dominance1;
    private double dominance2;
    private double multiplier;
    private double threshold1;
    private double threshold2;

    public InformationFlowQE(IndexReader indexReader, int expandTermNum, double expandCoeffi) {
        super(indexReader);
        this.indexReader = indexReader;
        this.expandTerm = expandTermNum;
        this.expandCoeffi = expandCoeffi;
        this.dominance1 = 0.5;
        this.dominance2 = 0.3;
        this.multiplier = 2.0;
        this.threshold1 = 0.0;
        this.threshold2 = 0.0;
    }

    public InformationFlowQE(HALSpace halSpace, IndexReader indexReader, int expandTermNum, double expandCoeffi) {
        super(indexReader);
        this.halMatrix = halSpace.getKnowledgeMatrix();
        this.halTermList = halSpace.getRowKeyList();
        this.indexReader = indexReader;
        this.expandTerm = expandTermNum;
        this.expandCoeffi = expandCoeffi;
        this.dominance1 = 0.5;
        this.dominance2 = 0.3;
        this.multiplier = 2.0;
        this.threshold1 = 0.0;
        this.threshold2 = 0.0;
    }

    public void setHALSpace(HALSpace halSpace) {
        this.halMatrix = halSpace.getKnowledgeMatrix();
        this.halTermList = halSpace.getRowKeyList();
    }

    public void setMultiplier(double multiplier) {
        if (multiplier < 1.0) {
            return;
        }
        this.multiplier = multiplier;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setDominantVectorWeight(double weight) {
        if (weight < 0.0 || weight > 1.0) {
            return;
        }
        this.dominance1 = weight;
    }

    public double getDominantVectorWeight() {
        return this.dominance1;
    }

    public void setSubordinateVectorWeight(double weight) {
        if (weight < 0.0 || weight > 1.0) {
            return;
        }
        this.dominance2 = weight;
    }

    public double getSubordinateVectorWeight() {
        return this.dominance2;
    }

    public void setDominantVectorThreshold(double threshold) {
        if (threshold < 0.0) {
            return;
        }
        this.threshold1 = threshold;
    }

    public double getDominantVectorThreshold() {
        return this.threshold1;
    }

    public void setSubordinateVectorThreshold(double threshold) {
        if (threshold < 0.0) {
            return;
        }
        this.threshold2 = threshold;
    }

    public double getSubordinateVectorThreshold() {
        return this.threshold2;
    }

    public IRQuery expand(IRQuery initQuery) {
        Token token2;
        if (!initQuery.isRelSimpleQuery()) {
            return null;
        }
        SimpleTermPredicate[] arrPredicate = this.checkSimpleTermQuery((RelSimpleQuery)initQuery);
        if (arrPredicate == null || arrPredicate.length == 0 || this.halMatrix == null) {
            return initQuery;
        }
        ArrayList<Token> oldList = new ArrayList<Token>();
        int docNum = this.indexReader.getCollection().getDocNum();
        int i = 0;
        while (i < arrPredicate.length) {
            int index = arrPredicate[i].getIndex();
            int halIndex = this.halTermList.search(arrPredicate[i].getKey());
            if (halIndex >= 0 && this.halMatrix.getNonZeroNumInRow(halIndex) > 0) {
                token2 = new Token(arrPredicate[i].getKey());
                token2.setIndex(halIndex);
                token2.setWeight(arrPredicate[i].getWeight() * Math.log((double)docNum * 1.0 / (double)this.indexReader.getIRTerm(index).getDocFrequency()));
                oldList.add(token2);
            }
            ++i;
        }
        if (oldList.size() == 0) {
            return initQuery;
        }
        ArrayList newList = this.expand(oldList, this.expandTerm);
        SimpleTermPredicate[] arrExpand = new SimpleTermPredicate[newList.size()];
        i = 0;
        while (i < arrExpand.length) {
            token2 = (Token)newList.get(i);
            arrExpand[i] = this.buildSimpleTermPredicate(token2.getIndex(), token2.getWeight());
            ++i;
        }
        return this.buildQuery(arrPredicate, arrExpand, this.expandCoeffi);
    }

    private ArrayList expand(ArrayList queryList, int top) {
        DoubleRow second;
        ArrayList<Token> candidates = new ArrayList<Token>(this.halMatrix.rows());
        ArrayList<Token> topList = new ArrayList<Token>(top);
        Collections.sort(queryList, new WeightComparator(true));
        Token token2 = (Token)queryList.get(0);
        int rowIndex = token2.getIndex();
        DoubleRow first = this.getVector(rowIndex);
        int i = 1;
        while (i < queryList.size()) {
            rowIndex = token2.getIndex();
            second = this.getVector(rowIndex);
            first = this.combineVector(first, second);
            ++i;
        }
        first = this.filterVector(first, this.getMeanScoreInVector(first));
        double sum2 = this.getSumScoreInVector(first);
        i = 0;
        while (i < this.halMatrix.rows()) {
            if (this.halMatrix.getNonZeroNumInRow(i) != 0) {
                second = this.getVector(i);
                token2 = new Token(null);
                token2.setIndex(i);
                token2.setWeight(this.intersect(first, second) / sum2);
                candidates.add(token2);
            }
            ++i;
        }
        Collections.sort(candidates, new WeightComparator(true));
        i = 0;
        while (i < top) {
            token2 = (Token)candidates.get(i);
            IRTerm term = this.indexReader.getIRTerm(this.halTermList.search(token2.getIndex()));
            if (term != null) {
                token2.setIndex(term.getIndex());
                topList.add(token2);
            }
            ++i;
        }
        candidates.clear();
        return topList;
    }

    private DoubleRow getVector(int index) {
        return new DoubleRow(index, this.halMatrix.getNonZeroNumInRow(index), this.halMatrix.getNonZeroColumnsInRow(index), this.halMatrix.getNonZeroDoubleScoresInRow(index));
    }

    private double intersect(DoubleRow first, DoubleRow second) {
        int i = 0;
        int j = 0;
        double sum2 = 0.0;
        int len1 = first.getNonZeroNum();
        int len2 = second.getNonZeroNum();
        while (i < len1 && j < len2) {
            int y;
            int x2 = first.getNonZeroColumn(i);
            if (x2 == (y = second.getNonZeroColumn(j))) {
                sum2 += first.getNonZeroDoubleScore(i);
                ++i;
                ++j;
                continue;
            }
            if (x2 < y) {
                ++i;
                continue;
            }
            ++j;
        }
        return sum2;
    }

    private DoubleRow combineVector(DoubleRow first, DoubleRow second) {
        first = this.reweightVector(first, this.dominance1);
        second = this.reweightVector(second, this.dominance2);
        this.strengthenCommonProperty(first, this.threshold1, second, this.threshold2, this.multiplier);
        DoubleRow vector = this.addVector(first, second);
        return this.normalizeVector(vector);
    }

    private DoubleRow filterVector(DoubleRow vector, double threshold) {
        Token curToken;
        int len = vector.getNonZeroNum();
        ArrayList<Token> tokenList = new ArrayList<Token>();
        int i = 0;
        while (i < len) {
            double score = vector.getNonZeroDoubleScore(i);
            if (score >= threshold) {
                curToken = new Token(null);
                curToken.setIndex(vector.getNonZeroColumn(i));
                curToken.setWeight(score);
                tokenList.add(curToken);
            }
            ++i;
        }
        int[] arrCol = new int[tokenList.size()];
        double[] arrScore = new double[tokenList.size()];
        i = 0;
        while (i < tokenList.size()) {
            curToken = (Token)tokenList.get(i);
            arrCol[i] = curToken.getIndex();
            arrScore[i] = curToken.getWeight();
            ++i;
        }
        return new DoubleRow(vector.getRowIndex(), tokenList.size(), arrCol, arrScore);
    }

    private double getMaxScoreInVector(DoubleRow vector) {
        double max2 = Double.MIN_VALUE;
        int len = vector.getNonZeroNum();
        int i = 0;
        while (i < len) {
            if (max2 < vector.getNonZeroDoubleScore(i)) {
                max2 = vector.getNonZeroDoubleScore(i);
            }
            ++i;
        }
        return max2;
    }

    private double getMeanScoreInVector(DoubleRow vector) {
        double mean = 0.0;
        int len = vector.getNonZeroNum();
        int i = 0;
        while (i < len) {
            mean += vector.getNonZeroDoubleScore(i);
            ++i;
        }
        return mean / (double)len;
    }

    private double getSumScoreInVector(DoubleRow vector) {
        double sum2 = 0.0;
        int len = vector.getNonZeroNum();
        int i = 0;
        while (i < len) {
            sum2 += vector.getNonZeroDoubleScore(i);
            ++i;
        }
        return sum2;
    }

    private DoubleRow reweightVector(DoubleRow vector, double scale) {
        int len = vector.getNonZeroNum();
        double max2 = this.getMaxScoreInVector(vector);
        int i = 0;
        while (i < len) {
            vector.setNonZeroDoubleScore(i, scale + vector.getNonZeroDoubleScore(i) * scale / max2);
            ++i;
        }
        return vector;
    }

    private DoubleRow normalizeVector(DoubleRow vector) {
        double sum2 = this.getSumScoreInVector(vector);
        return this.reweightVector(vector, 1.0 / sum2);
    }

    private void strengthenCommonProperty(DoubleRow first, double thresholdFirst, DoubleRow second, double thresholdSecond, double multiplier) {
        int i = 0;
        int j = 0;
        int len1 = first.getNonZeroNum();
        int len2 = second.getNonZeroNum();
        while (i < len1 && j < len2) {
            int y;
            double a = first.getNonZeroDoubleScore(i);
            if (a < thresholdFirst) {
                ++i;
                continue;
            }
            double b = second.getNonZeroDoubleScore(j);
            if (b < thresholdSecond) {
                ++j;
                continue;
            }
            int x2 = first.getNonZeroColumn(i);
            if (x2 == (y = second.getNonZeroColumn(j))) {
                first.setNonZeroDoubleScore(i, a * multiplier);
                second.setNonZeroDoubleScore(j, b * multiplier);
                ++i;
                ++j;
                continue;
            }
            if (x2 < y) {
                ++i;
                continue;
            }
            ++j;
        }
    }

    private DoubleRow addVector(DoubleRow first, DoubleRow second) {
        Token curToken;
        int i = 0;
        int j = 0;
        int len1 = first.getNonZeroNum();
        int len2 = second.getNonZeroNum();
        ArrayList<Token> tokenList = new ArrayList<Token>();
        while (i < len1 && j < len2) {
            int y;
            int x2 = first.getNonZeroColumn(i);
            if (x2 == (y = second.getNonZeroColumn(j))) {
                curToken = new Token(null);
                curToken.setIndex(x2);
                curToken.setWeight(first.getNonZeroDoubleScore(i) + second.getNonZeroDoubleScore(j));
                ++i;
                ++j;
            } else if (x2 < y) {
                curToken = new Token(null);
                curToken.setIndex(x2);
                curToken.setWeight(first.getNonZeroDoubleScore(i));
                ++i;
            } else {
                curToken = new Token(null);
                curToken.setIndex(y);
                curToken.setWeight(second.getNonZeroDoubleScore(j));
                ++j;
            }
            tokenList.add(curToken);
        }
        int k = i;
        while (k < len1) {
            curToken = new Token(null);
            curToken.setIndex(first.getNonZeroColumn(k));
            curToken.setWeight(first.getNonZeroDoubleScore(k));
            ++k;
            ++k;
        }
        k = j;
        while (k < len2) {
            curToken = new Token(null);
            curToken.setIndex(second.getNonZeroColumn(k));
            curToken.setWeight(second.getNonZeroDoubleScore(k));
            ++k;
            ++k;
        }
        int[] arrCol = new int[tokenList.size()];
        double[] arrScore = new double[tokenList.size()];
        i = 0;
        while (i < tokenList.size()) {
            curToken = (Token)tokenList.get(i);
            arrCol[i] = curToken.getIndex();
            arrScore[i] = curToken.getWeight();
            ++i;
        }
        return new DoubleRow(-1, tokenList.size(), arrCol, arrScore);
    }
}

