/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.AbstractSearcher;
import dragon.ir.search.smooth.Smoother;
import dragon.nlp.compare.WeightComparator;
import java.util.ArrayList;
import java.util.Collections;

public class FullRankSearcher
extends AbstractSearcher {
    private boolean docFirst;

    public FullRankSearcher(IndexReader indexReader, Smoother smoother) {
        super(indexReader, smoother);
        smoother.setLogLikelihoodOption(true);
        this.docFirst = !smoother.isQueryTermFirstOptimal();
    }

    public FullRankSearcher(IndexReader indexReader, Smoother smoother, boolean docFirst) {
        super(indexReader, smoother);
        smoother.setLogLikelihoodOption(true);
        this.docFirst = docFirst;
    }

    public int search(IRQuery query) {
        this.query = query;
        if (this.docFirst) {
            return this.breadthFirstSearch(query);
        }
        return this.depthFirstSearch(query);
    }

    public int breadthFirstSearch(IRQuery query) {
        if (!query.isRelSimpleQuery()) {
            this.hitlist = null;
            return 0;
        }
        int docNum = this.indexReader.getCollection().getDocNum();
        this.hitlist = new ArrayList(docNum);
        SimpleTermPredicate[] arrPredicate = this.checkSimpleTermQuery((RelSimpleQuery)query);
        if (arrPredicate == null || arrPredicate.length == 0) {
            this.hitlist = null;
            return 0;
        }
        int i = 0;
        while (i < docNum) {
            IRDoc curDoc = this.indexReader.getDoc(i);
            this.smoother.setDoc(curDoc);
            double weight = 0.0;
            int j = 0;
            while (j < arrPredicate.length) {
                IRTerm curTerm = this.indexReader.getIRTerm(arrPredicate[j].getIndex(), i);
                weight = curTerm != null ? (weight += this.smoother.getSmoothedProb(arrPredicate[j], curTerm.getFrequency())) : (weight += this.smoother.getSmoothedProb(arrPredicate[j]));
                ++j;
            }
            curDoc.setWeight(weight);
            this.hitlist.add(curDoc);
            ++i;
        }
        Collections.sort(this.hitlist, new WeightComparator(true));
        return this.hitlist.size();
    }

    /*
     * Unable to fully structure code
     */
    public int depthFirstSearch(IRQuery query) {
        if (!query.isRelSimpleQuery()) {
            this.hitlist = null;
            return 0;
        }
        docNum = this.indexReader.getCollection().getDocNum();
        this.hitlist = new ArrayList<E>(docNum);
        arrPredicate = this.checkSimpleTermQuery((RelSimpleQuery)query);
        if (arrPredicate == null || arrPredicate.length == 0) {
            this.hitlist = null;
            return 0;
        }
        arrDoc = new IRDoc[docNum];
        i = 0;
        while (i < docNum) {
            arrDoc[i] = this.indexReader.getDoc(i);
            arrDoc[i].setWeight(0.0);
            ++i;
        }
        i = 0;
        while (i < arrPredicate.length) {
            this.smoother.setQueryTerm(arrPredicate[i]);
            arrIndex = this.indexReader.getTermDocIndexList(arrPredicate[i].getIndex());
            arrFreq = this.indexReader.getTermDocFrequencyList(arrPredicate[i].getIndex());
            k = 0;
            j = 0;
            ** GOTO lbl32
            {
                arrDoc[k].setWeight(arrDoc[k].getWeight() + this.smoother.getSmoothedProb(arrDoc[k]));
                ++k;
                do {
                    if (k < arrIndex[j]) continue block2;
                    arrDoc[k].setWeight(arrDoc[k].getWeight() + this.smoother.getSmoothedProb(arrDoc[k], arrFreq[j]));
                    ++k;
                    ++j;
lbl32:
                    // 2 sources

                } while (j < arrIndex.length);
            }
            while (k < docNum) {
                arrDoc[k].setWeight(arrDoc[k].getWeight() + this.smoother.getSmoothedProb(arrDoc[k]));
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < docNum) {
            this.hitlist.add(arrDoc[i]);
            ++i;
        }
        Collections.sort(this.hitlist, new WeightComparator(true));
        return this.hitlist.size();
    }
}

