/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.query;

import dragon.ir.query.IRQuery;
import dragon.ir.query.Operator;
import java.util.ArrayList;

public abstract class AbstractIRQuery
implements IRQuery {
    protected Operator optr;
    protected ArrayList children;
    private int queryKey;

    public int getQueryKey() {
        return this.queryKey;
    }

    public void setQueryKey(int key) {
        this.queryKey = key;
    }

    public boolean isPredicate() {
        return false;
    }

    public boolean isCompoundQuery() {
        return true;
    }

    public boolean isRelSimpleQuery() {
        return false;
    }

    public boolean isRelBoolQuery() {
        return false;
    }

    public boolean parse(String query) {
        this.parse(this.getTokenList(query));
        return true;
    }

    public int getChildNum() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public IRQuery getChild(int index) {
        if (index >= this.getChildNum() || index < 0) {
            return null;
        }
        return (IRQuery)this.children.get(index);
    }

    public double getSelectivity() {
        return 0.0;
    }

    public Operator getOperator() {
        return this.optr;
    }

    public String toString() {
        if (this.getChildNum() == 0) {
            return null;
        }
        if (this.getChildNum() == 1) {
            return this.getChild(0).toString();
        }
        StringBuffer buf = new StringBuffer();
        if (this.optr.toString().equalsIgnoreCase("OR")) {
            buf.append('(');
        }
        int i = 0;
        while (i < this.getChildNum()) {
            buf.append(this.getChild(i).toString());
            if (i < this.getChildNum() - 1) {
                buf.append(' ');
                buf.append(this.getOperator().toString());
                buf.append(' ');
            }
            ++i;
        }
        if (this.optr.toString().equalsIgnoreCase("OR")) {
            buf.append(')');
        }
        return buf.toString();
    }

    protected String[] getTokenList(String query) {
        boolean lastSpace = false;
        StringBuffer sb = new StringBuffer(query.length());
        int i = 0;
        while (i < query.length()) {
            if ("()=,".indexOf(query.charAt(i)) >= 0) {
                if (!lastSpace) {
                    sb.append(' ');
                }
                sb.append(query.charAt(i));
                sb.append(' ');
                lastSpace = true;
            } else if (query.charAt(i) != ' ') {
                sb.append(query.charAt(i));
                lastSpace = false;
            } else if (!lastSpace) {
                sb.append(' ');
                lastSpace = true;
            }
            ++i;
        }
        query = sb.toString().trim();
        String[] arrToken = query.split(" ");
        return arrToken;
    }

    protected abstract void parse(String[] var1);
}

