/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.kngbase;

import dragon.ir.index.IndexReader;
import dragon.matrix.DoubleFlatSparseMatrix;
import dragon.matrix.DoubleSparseMatrix;
import dragon.matrix.DoubleSuperSparseMatrix;
import dragon.nlp.Token;
import dragon.util.MathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

public class DocRepresentation {
    private IndexReader indexReader;
    private int[] termMap;
    private boolean showMessage;

    public DocRepresentation(IndexReader indexReader) {
        this.indexReader = indexReader;
        this.showMessage = true;
    }

    public DocRepresentation(IndexReader indexReader, int[] termMap) {
        this.indexReader = indexReader;
        this.termMap = termMap;
        this.showMessage = true;
    }

    public void setMessageOption(boolean showMessage) {
        this.showMessage = showMessage;
    }

    public DoubleSparseMatrix genModelMatrix(IndexReader signatureIndexReader, DoubleSparseMatrix transMatrix, double transCoefficient, double bkgCoefficient, boolean isPhraseSignature, double probThreshold, String matrixPath, String matrixKey) {
        return this.genModelMatrix(signatureIndexReader, null, transMatrix, transCoefficient, bkgCoefficient, isPhraseSignature, probThreshold, matrixPath, matrixKey);
    }

    public DoubleSparseMatrix genModelMatrix(IndexReader signatureIndexReader, int[] signatureMap, DoubleSparseMatrix transMatrix, double transCoefficient, double bkgCoefficient, boolean isPhraseSignature, double probThreshold, String matrixPath, String matrixKey) {
        String indexDir = matrixPath;
        File file = new File(indexDir + "/" + matrixKey + ".index");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(indexDir + "/" + matrixKey + ".matrix")).exists()) {
            file.delete();
        }
        DoubleSuperSparseMatrix matrix = new DoubleSuperSparseMatrix(indexDir + "/" + matrixKey + ".index", indexDir + "/" + matrixKey + ".matrix", false, false);
        return this.genModelMatrix(signatureIndexReader, signatureMap, transMatrix, transCoefficient, bkgCoefficient, isPhraseSignature, probThreshold, matrix);
    }

    public DoubleSparseMatrix genModelMatrix(IndexReader signatureIndexReader, DoubleSparseMatrix transMatrix, double transCoefficient, double bkgCoefficient, boolean isPhraseSignature, double probThreshold) {
        return this.genModelMatrix(signatureIndexReader, null, transMatrix, transCoefficient, bkgCoefficient, isPhraseSignature, probThreshold);
    }

    public DoubleSparseMatrix genModelMatrix(IndexReader signatureIndexReader, int[] signatureMap, DoubleSparseMatrix transMatrix, double transCoefficient, double bkgCoefficient, boolean isPhraseSignature, double probThreshold) {
        DoubleFlatSparseMatrix matrix = new DoubleFlatSparseMatrix(false, false);
        return this.genModelMatrix(signatureIndexReader, signatureMap, transMatrix, transCoefficient, bkgCoefficient, isPhraseSignature, probThreshold, matrix);
    }

    private DoubleSparseMatrix genModelMatrix(IndexReader signatureIndexReader, int[] signatureMap, DoubleSparseMatrix transMatrix, double transCoefficient, double bkgCoefficient, boolean isPhraseSignature, double probThreshold, DoubleSparseMatrix matrix) {
        int docNum = this.indexReader.getCollection().getDocNum();
        int termNum = this.termMap == null ? this.indexReader.getCollection().getTermNum() : Math.max(transMatrix.columns(), MathUtil.max(this.termMap) + 1);
        double[] arrBkgModel = new double[this.indexReader.getCollection().getTermNum()];
        double[] arrTransModel = new double[termNum];
        double weightSum = this.indexReader.getCollection().getTermCount();
        int i = 0;
        while (i < arrBkgModel.length) {
            arrBkgModel[i] = (double)this.indexReader.getIRTerm(i).getFrequency() / weightSum * (1.0 - transCoefficient) * bkgCoefficient;
            ++i;
        }
        ArrayList<Token> termList = new ArrayList<Token>();
        int[] indexList = null;
        int[] freqList = null;
        i = 0;
        while (i < docNum) {
            if (i > 0 && i % 2000 == 0) {
                matrix.flush();
                if (this.showMessage) {
                    System.out.println(new Date() + " processing doc #" + i);
                }
            }
            if (this.indexReader.getDoc(i).getTermNum() > 0) {
                Token curToken;
                double rate;
                int j;
                int signatureNum;
                if (i >= signatureIndexReader.getCollection().getDocNum()) {
                    signatureNum = 0;
                } else {
                    j = 0;
                    while (j < termNum) {
                        arrTransModel[j] = 0.0;
                        ++j;
                    }
                    if (isPhraseSignature) {
                        signatureNum = signatureIndexReader.getDoc(i).getTermNum();
                        indexList = signatureIndexReader.getTermIndexList(i);
                        freqList = signatureIndexReader.getTermFrequencyList(i);
                    } else {
                        signatureNum = signatureIndexReader.getDoc(i).getRelationNum();
                        indexList = signatureIndexReader.getRelationIndexList(i);
                        freqList = signatureIndexReader.getRelationFrequencyList(i);
                    }
                }
                int usedSignature = 0;
                weightSum = 0.0;
                j = 0;
                while (j < signatureNum) {
                    int curSignatureIndex = signatureMap == null ? indexList[j] : signatureMap[indexList[j]];
                    if (curSignatureIndex >= transMatrix.rows()) break;
                    int[] cols = transMatrix.getNonZeroColumnsInRow(curSignatureIndex);
                    double[] scores = transMatrix.getNonZeroDoubleScoresInRow(curSignatureIndex);
                    if (cols.length > 0) {
                        ++usedSignature;
                    }
                    rate = freqList[j];
                    weightSum += (double)freqList[j];
                    int k = 0;
                    while (k < cols.length) {
                        int n = cols[k];
                        arrTransModel[n] = arrTransModel[n] + scores[k] * rate;
                        ++k;
                    }
                    ++j;
                }
                if (usedSignature > 0) {
                    rate = transCoefficient / (double)usedSignature / weightSum;
                    j = 0;
                    while (j < termNum) {
                        if (arrTransModel[j] > 0.0) {
                            arrTransModel[j] = arrTransModel[j] * rate;
                        }
                        ++j;
                    }
                }
                indexList = this.indexReader.getTermIndexList(i);
                freqList = this.indexReader.getTermFrequencyList(i);
                weightSum = this.indexReader.getDoc(i).getTermCount();
                rate = (1.0 - transCoefficient) * (1.0 - bkgCoefficient) / weightSum;
                j = 0;
                while (j < indexList.length) {
                    int n = this.map(indexList[j]);
                    arrTransModel[n] = arrTransModel[n] + (double)freqList[j] * rate;
                    ++j;
                }
                j = 0;
                while (j < arrBkgModel.length) {
                    int n = this.map(j);
                    arrTransModel[n] = arrTransModel[n] + arrBkgModel[j];
                    ++j;
                }
                if (usedSignature == 0) {
                    rate = 1.0 / (1.0 - transCoefficient);
                    j = 0;
                    while (j < termNum) {
                        arrTransModel[j] = arrTransModel[j] * rate;
                        ++j;
                    }
                }
                termList.clear();
                weightSum = 0.0;
                j = 0;
                while (j < termNum) {
                    if (arrTransModel[j] >= probThreshold) {
                        curToken = new Token(null);
                        curToken.setIndex(j);
                        curToken.setWeight(arrTransModel[j]);
                        termList.add(curToken);
                        weightSum += arrTransModel[j];
                    }
                    ++j;
                }
                j = 0;
                while (j < termList.size()) {
                    curToken = (Token)termList.get(j);
                    matrix.add(i, curToken.getIndex(), curToken.getWeight() / weightSum);
                    ++j;
                }
            }
            ++i;
        }
        matrix.finalizeData();
        return matrix;
    }

    public DoubleSparseMatrix genTFIDFMatrix(String matrixPath, String matrixKey) {
        String indexFolder = matrixPath;
        File file = new File(indexFolder + "/" + matrixKey + ".index");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(indexFolder + "/" + matrixKey + ".matrix")).exists()) {
            file.delete();
        }
        DoubleSuperSparseMatrix tfidfMatrix = new DoubleSuperSparseMatrix(indexFolder + "/" + matrixKey + ".index", indexFolder + "/" + matrixKey + ".matrix", false, false);
        return this.genTFIDFMatrix(tfidfMatrix);
    }

    public DoubleSparseMatrix genTFIDFMatrix() {
        DoubleFlatSparseMatrix matrix = new DoubleFlatSparseMatrix(false, false);
        return this.genTFIDFMatrix(matrix);
    }

    private DoubleSparseMatrix genTFIDFMatrix(DoubleSparseMatrix matrix) {
        double[] arrIDF = new double[this.indexReader.getCollection().getTermNum()];
        double sum2 = this.indexReader.getCollection().getDocNum();
        int i = 0;
        while (i < arrIDF.length) {
            arrIDF[i] = Math.log(sum2 / (double)this.indexReader.getIRTerm(i).getDocFrequency());
            ++i;
        }
        int docNum = this.indexReader.getCollection().getDocNum();
        i = 0;
        while (i < docNum) {
            if (i > 0 && i % 2000 == 0) {
                matrix.flush();
                if (this.showMessage) {
                    System.out.println(new Date() + " processing doc #" + i);
                }
            }
            int[] termIndexList = this.indexReader.getTermIndexList(i);
            int[] termFreqList = this.indexReader.getTermFrequencyList(i);
            int j = 0;
            while (j < termIndexList.length) {
                matrix.add(i, this.map(termIndexList[j]), (double)termFreqList[j] * arrIDF[termIndexList[j]]);
                ++j;
            }
            ++i;
        }
        matrix.finalizeData();
        return matrix;
    }

    public DoubleSparseMatrix genNormTFMatrix(String matrixPath, String matrixKey) {
        String indexFolder = matrixPath;
        File file = new File(indexFolder + "/" + matrixKey + ".index");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(indexFolder + "/" + matrixKey + ".matrix")).exists()) {
            file.delete();
        }
        DoubleSuperSparseMatrix matrix = new DoubleSuperSparseMatrix(indexFolder + "/" + matrixKey + ".index", indexFolder + "/" + matrixKey + ".matrix", false, false);
        return this.genNormTFMatrix(matrix);
    }

    public DoubleSparseMatrix genNormTFMatrix() {
        DoubleFlatSparseMatrix matrix = new DoubleFlatSparseMatrix(false, false);
        return this.genNormTFMatrix(matrix);
    }

    private DoubleSparseMatrix genNormTFMatrix(DoubleSparseMatrix matrix) {
        double docNum = this.indexReader.getCollection().getDocNum();
        int i = 0;
        while ((double)i < docNum) {
            if (i > 0 && i % 2000 == 0) {
                matrix.flush();
                if (this.showMessage) {
                    System.out.println(new Date() + " processing doc #" + i);
                }
            }
            int[] termIndexList = this.indexReader.getTermIndexList(i);
            int[] termFreqList = this.indexReader.getTermFrequencyList(i);
            double sum2 = 0.0;
            int j = 0;
            while (j < termIndexList.length) {
                sum2 += (double)termFreqList[j] * (double)termFreqList[j];
                ++j;
            }
            sum2 = Math.sqrt(sum2);
            j = 0;
            while (j < termIndexList.length) {
                matrix.add(i, this.map(termIndexList[j]), (double)termFreqList[j] / sum2);
                ++j;
            }
            ++i;
        }
        matrix.finalizeData();
        return matrix;
    }

    private int map(int oldTermIndex) {
        if (this.termMap == null) {
            return oldTermIndex;
        }
        return this.termMap[oldTermIndex];
    }
}

