/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.kngbase;

import dragon.matrix.IntSparseMatrix;
import dragon.matrix.IntSuperSparseMatrix;
import dragon.matrix.SparseMatrixFactory;
import dragon.nlp.Counter;
import dragon.nlp.SimplePair;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class CooccurrenceGenerator {
    private HashMap hashMap = new HashMap();
    private int cacheSize = 3000000;
    private int minDocFreq = 1;
    private int maxDocFreq = Integer.MAX_VALUE;

    public void setMinDocFrequency(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public int getMinDocFrequency() {
        return this.minDocFreq;
    }

    public void setMaxDocFrequency(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
    }

    public int getMaxDocFrequency() {
        return this.maxDocFreq;
    }

    public void setCacheSize(int size2) {
        this.cacheSize = size2;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public boolean generate(IntSparseMatrix doctermMatrixA, IntSparseMatrix doctermMatrixB, String matrixFolder, String matrixKey) {
        return this.generate(doctermMatrixA, null, doctermMatrixB, null, matrixFolder, matrixKey);
    }

    public boolean generate(IntSparseMatrix doctermMatrixA, int[] termDocFreqA, IntSparseMatrix doctermMatrixB, int[] termDocFreqB, String matrixFolder, String matrixKey) {
        try {
            boolean[] usedListA = this.checkTermDocFrequency(doctermMatrixA.columns(), termDocFreqA);
            boolean[] usedListB = this.checkTermDocFrequency(doctermMatrixB.columns(), termDocFreqB);
            String matrixFile = matrixFolder + "/" + matrixKey + ".matrix";
            String indexFile = matrixFolder + "/" + matrixKey + ".index";
            File file = new File(matrixFile);
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(indexFile)).exists()) {
                file.delete();
            }
            IntSuperSparseMatrix cooccurMatrix = new IntSuperSparseMatrix(indexFile, matrixFile, false, false);
            SparseMatrixFactory smf = null;
            String tmpMatrixFile = matrixFolder + "/" + matrixKey + "tmp.matrix";
            String tmpIndexFile = matrixFolder + "/" + matrixKey + "tmp.index";
            int docNum = Math.min(doctermMatrixA.rows(), doctermMatrixB.rows());
            boolean isFirst = true;
            SimplePair.setHashCapacity(doctermMatrixA.columns());
            int i = 0;
            while (i < docNum) {
                if (i % 1000 == 0) {
                    System.out.println(new Date() + " " + i);
                }
                if (this.hashMap.size() >= this.cacheSize) {
                    if (isFirst) {
                        this.convertPairsToMatrix(this.hashMap, cooccurMatrix, false);
                        isFirst = false;
                        smf = new SparseMatrixFactory(matrixFolder + "/" + matrixKey + ".matrix", 4);
                    } else {
                        cooccurMatrix = new IntSuperSparseMatrix(tmpIndexFile, tmpMatrixFile, false, false);
                        this.convertPairsToMatrix(this.hashMap, cooccurMatrix, false);
                        smf.add(cooccurMatrix);
                        cooccurMatrix.close();
                        new File(tmpIndexFile).delete();
                        new File(tmpMatrixFile).delete();
                    }
                }
                int[] indexListA = doctermMatrixA.getNonZeroColumnsInRow(i);
                int[] indexListB = doctermMatrixB.getNonZeroColumnsInRow(i);
                int j = 0;
                while (j < indexListA.length) {
                    if (usedListA[indexListA[j]]) {
                        int k = 0;
                        while (k < indexListB.length) {
                            if (usedListB[indexListB[k]]) {
                                SimplePair coOccurPair = new SimplePair(-1, indexListA[j], indexListB[k]);
                                Counter counter = (Counter)this.hashMap.get(coOccurPair);
                                if (counter != null) {
                                    counter.addCount(1);
                                } else {
                                    this.hashMap.put(coOccurPair, new Counter(1));
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (this.hashMap.size() > 0) {
                if (isFirst) {
                    this.convertPairsToMatrix(this.hashMap, cooccurMatrix, false);
                } else {
                    cooccurMatrix = new IntSuperSparseMatrix(tmpIndexFile, tmpMatrixFile, false, false);
                    this.convertPairsToMatrix(this.hashMap, cooccurMatrix, false);
                    smf.add(cooccurMatrix);
                    cooccurMatrix.close();
                    new File(tmpIndexFile).delete();
                    new File(tmpMatrixFile).delete();
                    smf.genIndexFile(matrixFolder + "/" + matrixKey + ".index");
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean generate(IntSparseMatrix doctermMatrix, String matrixFolder, String matrixKey) {
        return this.generate(doctermMatrix, new int[0], matrixFolder, matrixKey);
    }

    public boolean generate(IntSparseMatrix doctermMatrix, int[] termDocFreq, String matrixFolder, String matrixKey) {
        try {
            boolean[] usedList = this.checkTermDocFrequency(doctermMatrix.columns(), termDocFreq);
            String matrixFile = matrixFolder + "/" + matrixKey + ".matrix";
            String indexFile = matrixFolder + "/" + matrixKey + ".index";
            File file = new File(matrixFile);
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(indexFile)).exists()) {
                file.delete();
            }
            IntSuperSparseMatrix cooccurMatrix = new IntSuperSparseMatrix(indexFile, matrixFile, false, false);
            SparseMatrixFactory smf = null;
            String tmpMatrixFile = matrixFolder + "/" + matrixKey + "tmp.matrix";
            String tmpIndexFile = matrixFolder + "/" + matrixKey + "tmp.index";
            boolean isFirst = true;
            SimplePair.setHashCapacity(doctermMatrix.rows());
            int i = 0;
            while (i < doctermMatrix.rows()) {
                if (i % 1000 == 0) {
                    System.out.println(new Date() + " " + i);
                }
                if (this.hashMap.size() >= this.cacheSize) {
                    if (isFirst) {
                        this.convertPairsToMatrix(this.hashMap, cooccurMatrix, true);
                        isFirst = false;
                        smf = new SparseMatrixFactory(matrixFolder + "/" + matrixKey + ".matrix", 4);
                    } else {
                        cooccurMatrix = new IntSuperSparseMatrix(tmpIndexFile, tmpMatrixFile, false, false);
                        this.convertPairsToMatrix(this.hashMap, cooccurMatrix, true);
                        smf.add(cooccurMatrix);
                        cooccurMatrix.close();
                        new File(tmpIndexFile).delete();
                        new File(tmpMatrixFile).delete();
                    }
                }
                int[] indexList = doctermMatrix.getNonZeroColumnsInRow(i);
                int j = 0;
                while (j < indexList.length) {
                    if (usedList[indexList[j]]) {
                        int k = j + 1;
                        while (k < indexList.length) {
                            if (usedList[indexList[k]]) {
                                SimplePair coOccurPair = new SimplePair(-1, indexList[j], indexList[k]);
                                Counter counter = (Counter)this.hashMap.get(coOccurPair);
                                if (counter != null) {
                                    counter.addCount(1);
                                } else {
                                    this.hashMap.put(coOccurPair, new Counter(1));
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (this.hashMap.size() > 0) {
                if (isFirst) {
                    this.convertPairsToMatrix(this.hashMap, cooccurMatrix, true);
                } else {
                    cooccurMatrix = new IntSuperSparseMatrix(tmpIndexFile, tmpMatrixFile, false, false);
                    this.convertPairsToMatrix(this.hashMap, cooccurMatrix, true);
                    smf.add(cooccurMatrix);
                    cooccurMatrix.close();
                    new File(tmpIndexFile).delete();
                    new File(tmpMatrixFile).delete();
                    smf.genIndexFile(matrixFolder + "/" + matrixKey + ".index");
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void convertPairsToMatrix(HashMap hashMap, IntSuperSparseMatrix matrix, boolean symmetric) {
        if (symmetric) {
            matrix.setFlushInterval(2 * hashMap.size() + 1);
        } else {
            matrix.setFlushInterval(hashMap.size() + 1);
        }
        Set keySet = hashMap.keySet();
        Iterator iterator2 = keySet.iterator();
        while (iterator2.hasNext()) {
            SimplePair coOccurPair = (SimplePair)iterator2.next();
            Counter counter = (Counter)hashMap.get(coOccurPair);
            matrix.add(coOccurPair.getFirstElement(), coOccurPair.getSecondElement(), counter.getCount());
            if (!symmetric || coOccurPair.getFirstElement() == coOccurPair.getSecondElement()) continue;
            matrix.add(coOccurPair.getSecondElement(), coOccurPair.getFirstElement(), counter.getCount());
        }
        matrix.finalizeData();
        hashMap.clear();
    }

    private boolean[] checkTermDocFrequency(int termNum, int[] arrTermDocFreq) {
        boolean[] usedList = new boolean[termNum];
        int i = 0;
        while (i < termNum) {
            usedList[i] = true;
            ++i;
        }
        if (arrTermDocFreq == null || arrTermDocFreq.length == 0 || this.minDocFreq <= 1) {
            return usedList;
        }
        i = 0;
        while (i < termNum) {
            if (arrTermDocFreq[i] < this.minDocFreq || arrTermDocFreq[i] > this.maxDocFreq) {
                usedList[i] = false;
            }
            ++i;
        }
        return usedList;
    }
}

