/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sequence;

import dragon.ir.index.sequence.SequenceWriter;
import dragon.util.FastBinaryReader;
import dragon.util.FastBinaryWriter;
import java.io.File;
import java.io.RandomAccessFile;

public class SequenceFileWriter
implements SequenceWriter {
    private static final int BUF_THRESHOLD = 512000;
    private String seqIndexFile;
    private String seqMatrixFile;
    private FastBinaryWriter matrixFile;
    private FastBinaryWriter indexFile;
    private int maxRowIndex;
    private int maxTermIndex;
    private int termCount;

    public SequenceFileWriter(String seqIndexFile, String seqMatrixFile) {
        this.seqIndexFile = seqIndexFile;
        this.seqMatrixFile = seqMatrixFile;
        this.init();
    }

    public void initialize() {
    }

    public boolean addSequence(int rowIndex, int[] seq2) {
        try {
            if (rowIndex <= this.maxRowIndex) {
                return false;
            }
            int i = this.maxRowIndex + 1;
            while (i < rowIndex) {
                this.indexFile.writeInt(i);
                this.indexFile.writeLong(this.matrixFile.getFilePointer());
                this.indexFile.writeInt(0);
                this.matrixFile.writeInt(i);
                this.matrixFile.writeInt(0);
                ++i;
            }
            this.indexFile.writeInt(rowIndex);
            this.indexFile.writeLong(this.matrixFile.getFilePointer());
            this.indexFile.writeInt(seq2.length);
            this.matrixFile.writeInt(rowIndex);
            this.matrixFile.writeInt(seq2.length);
            i = 0;
            while (i < seq2.length) {
                if (seq2[i] > this.maxTermIndex) {
                    this.maxTermIndex = seq2[i];
                }
                this.matrixFile.writeInt(seq2[i]);
                ++i;
            }
            this.termCount += seq2.length;
            if (this.indexFile.bytesInBuffer() > 512000) {
                this.indexFile.flush();
            }
            if (this.matrixFile.bytesInBuffer() > 512000) {
                this.matrixFile.flush();
            }
            this.maxRowIndex = rowIndex;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        if (this.matrixFile != null) {
            this.matrixFile.close();
            this.editHeader(this.seqMatrixFile);
        }
        if (this.indexFile != null) {
            this.indexFile.close();
            this.editHeader(this.seqIndexFile);
        }
    }

    private void init() {
        try {
            File file = new File(this.seqMatrixFile);
            if (!file.exists() || file.length() == 0L) {
                this.maxRowIndex = -1;
                this.maxTermIndex = -1;
                this.termCount = 0;
            } else {
                FastBinaryReader fbr = new FastBinaryReader(file);
                this.maxRowIndex = fbr.readInt() - 1;
                this.maxTermIndex = fbr.readInt() - 1;
                this.termCount = fbr.readInt();
                fbr.close();
            }
            this.matrixFile = new FastBinaryWriter(this.seqMatrixFile, true);
            if (this.matrixFile.getFilePointer() == 0L) {
                this.matrixFile.writeInt(0);
                this.matrixFile.writeInt(0);
                this.matrixFile.writeInt(0);
            }
            this.indexFile = new FastBinaryWriter(this.seqIndexFile, true);
            if (this.indexFile.getFilePointer() == 0L) {
                this.indexFile.writeInt(0);
                this.indexFile.writeInt(0);
                this.indexFile.writeInt(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void editHeader(String file) {
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            raf.writeInt(this.maxRowIndex + 1);
            raf.writeInt(this.maxTermIndex + 1);
            raf.writeInt(this.termCount);
            raf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

