/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sequence;

import dragon.ir.index.sequence.SequenceReader;
import dragon.util.FastBinaryReader;
import java.io.RandomAccessFile;

public class SequenceFileReader
implements SequenceReader {
    private RandomAccessFile rafMatrix;
    private long[] arrRowStart;
    private int rowNum;

    public SequenceFileReader(String seqIndexFile, String seqMatrixFile) {
        try {
            this.loadIndexFile(seqIndexFile);
            this.rafMatrix = new RandomAccessFile(seqMatrixFile, "r");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize() {
    }

    public int getSequenceLength(int seqIndex) {
        if (seqIndex < 0 || seqIndex >= this.rowNum) {
            return 0;
        }
        return (int)((this.arrRowStart[seqIndex + 1] - this.arrRowStart[seqIndex] - 8L) / 4L);
    }

    public int[] getSequence(int seqIndex) {
        try {
            int len = this.getSequenceLength(seqIndex);
            if (len <= 0) {
                return null;
            }
            this.rafMatrix.seek(this.arrRowStart[seqIndex] + 8L);
            FastBinaryReader fbr = new FastBinaryReader(this.rafMatrix, len * 4);
            int[] arrSeq = new int[len];
            int i = 0;
            while (i < len) {
                arrSeq[i] = fbr.readInt();
                ++i;
            }
            return arrSeq;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close() {
        try {
            if (this.rafMatrix != null) {
                this.rafMatrix.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadIndexFile(String indexFile) {
        try {
            int len = 0;
            FastBinaryReader fbr = new FastBinaryReader(indexFile);
            this.rowNum = fbr.readInt();
            fbr.readInt();
            fbr.readInt();
            this.arrRowStart = new long[this.rowNum + 1];
            int i = 0;
            while (i < this.rowNum) {
                fbr.readInt();
                this.arrRowStart[i] = fbr.readLong();
                len = fbr.readInt();
                ++i;
            }
            this.arrRowStart[this.rowNum] = this.arrRowStart[this.rowNum - 1] + (long)((len + 2) * 4);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

