/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sequence;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDocIndexList;
import dragon.ir.index.IRTermIndexList;
import dragon.ir.index.OnlineIRDocIndexList;
import dragon.ir.index.OnlineIRTermIndexList;
import dragon.ir.index.sequence.AbstractSequenceIndexWriter;
import dragon.ir.index.sequence.OnlineSequenceBase;
import dragon.ir.index.sequence.SequenceReader;
import dragon.nlp.SimpleElementList;
import dragon.util.SortedArray;

public class OnlineSequenceIndexWriter
extends AbstractSequenceIndexWriter {
    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.collection = new IRCollection();
        this.termCache = new SortedArray(500);
        this.docKeyList = new SimpleElementList();
        this.termKeyList = new SimpleElementList();
        this.docIndexList = new OnlineIRDocIndexList();
        this.termIndexList = new OnlineIRTermIndexList();
        this.doctermMatrix = new OnlineSequenceBase();
        this.initialized = true;
    }

    public void close() {
        this.flush();
        this.initialized = false;
    }

    public void clean() {
        this.termIndexList.close();
        this.docIndexList.close();
        this.doctermMatrix.close();
        this.docKeyList.close();
        this.termKeyList.close();
    }

    public IRTermIndexList getTermIndexList() {
        return this.termIndexList;
    }

    public IRDocIndexList getDocIndexList() {
        return this.docIndexList;
    }

    public SimpleElementList getDocKeyList() {
        return this.docKeyList;
    }

    public SimpleElementList getTermKeyList() {
        return this.termKeyList;
    }

    public IRCollection getIRCollection() {
        return this.collection;
    }

    public SequenceReader getSequenceReader() {
        return (SequenceReader)((Object)this.doctermMatrix);
    }
}

