/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sequence;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.Indexer;
import dragon.ir.index.sequence.AbstractSequenceIndexWriter;
import dragon.nlp.Token;
import dragon.nlp.extract.ConceptExtractor;
import dragon.onlinedb.Article;
import dragon.util.FileUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;

public abstract class AbstractSequenceIndexer
implements Indexer {
    private ConceptExtractor ce;
    private PrintWriter log;
    protected AbstractSequenceIndexWriter writer;
    protected boolean initialized;
    private boolean useTitle;
    private boolean useAbstract;
    private boolean useBody;
    private boolean useMeta;

    public AbstractSequenceIndexer(ConceptExtractor ce) {
        this.ce = ce;
        this.useTitle = true;
        this.useAbstract = true;
        this.useMeta = false;
        this.useBody = true;
    }

    public void setSectionIndexOption(boolean title, boolean abt, boolean body, boolean meta) {
        this.useMeta = meta;
        this.useTitle = title;
        this.useAbstract = abt;
        this.useBody = body;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.writer.initialize();
        this.initialized = true;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.log != null) {
            this.log.close();
        }
        this.initialized = false;
    }

    public boolean index(Article article) {
        try {
            StringBuffer sb = new StringBuffer();
            if (this.useTitle && article.getTitle() != null) {
                if (sb.length() > 0) {
                    sb.append("\n\n");
                }
                sb.append(article.getTitle());
            }
            if (this.useAbstract && article.getAbstract() != null) {
                if (sb.length() > 0) {
                    sb.append("\n\n");
                }
                sb.append(article.getAbstract());
            }
            if (this.useBody && article.getBody() != null) {
                if (sb.length() > 0) {
                    sb.append("\n\n");
                }
                sb.append(article.getBody());
            }
            if (this.useMeta && article.getMeta() != null) {
                if (sb.length() > 0) {
                    sb.append("\n\n");
                }
                sb.append(article.getMeta());
            }
            if (sb.length() <= 0) {
                this.writeLog(new Date().toString() + " Indexing article #" + article.getKey() + ": no content\n");
                return false;
            }
            IRDoc curDoc = new IRDoc(article.getKey());
            ArrayList list2 = this.ce.extractFromDoc(sb.toString());
            IRTerm[] arrTerm = new IRTerm[list2.size()];
            int i = 0;
            while (i < list2.size()) {
                arrTerm[i] = new IRTerm(((Token)list2.get(i)).getName(), -1, 1);
                ++i;
            }
            boolean result2 = this.writer.write(curDoc, arrTerm);
            if (result2) {
                this.writeLog(new Date().toString() + " Indexing article #" + article.getKey() + ": successful\n");
            } else {
                this.writeLog(new Date().toString() + " Indexing article #" + article.getKey() + ": failed\n");
            }
            return result2;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeLog(new Date().toString() + " Indexing article #" + article.getKey() + ": failed\n");
            return false;
        }
    }

    public void setLog(String logFile) {
        this.log = FileUtil.getPrintWriter(logFile);
    }

    public boolean indexed(String docKey) {
        return this.writer.indexed(docKey);
    }

    protected void writeLog(String content) {
        if (this.log != null) {
            this.log.write(content);
            this.log.flush();
        }
    }
}

