/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sentence;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDocIndexList;
import dragon.ir.index.IRRelationIndexList;
import dragon.ir.index.IRTermIndexList;
import dragon.ir.index.sentence.AbstractSentenceIndexer;
import dragon.ir.index.sentence.OnlineSentenceBase;
import dragon.ir.index.sentence.OnlineSentenceWriteController;
import dragon.matrix.IntSparseMatrix;
import dragon.nlp.Sentence;
import dragon.nlp.SimpleElementList;
import dragon.nlp.SimplePairList;
import dragon.nlp.extract.ConceptExtractor;
import dragon.nlp.extract.TripleExtractor;
import java.util.ArrayList;

public class OnlineSentenceIndexer
extends AbstractSentenceIndexer {
    private OnlineSentenceWriteController writer;
    private ConceptExtractor cptExtractor;
    private TripleExtractor tripleExtractor;

    public OnlineSentenceIndexer(ConceptExtractor extractor, boolean useConcept) {
        super(extractor.getDocumentParser());
        this.cptExtractor = extractor;
        this.writer = new OnlineSentenceWriteController(false, useConcept);
    }

    public OnlineSentenceIndexer(TripleExtractor extractor, boolean useConcept) {
        super(extractor.getConceptExtractor().getDocumentParser());
        this.tripleExtractor = extractor;
        this.cptExtractor = extractor.getConceptExtractor();
        this.writer = new OnlineSentenceWriteController(true, useConcept);
    }

    public boolean indexedSentence(String sentKey) {
        return this.writer.indexed(sentKey);
    }

    public boolean isRelationSupported() {
        return this.writer.isRelationSupported();
    }

    public boolean index(Sentence sent, String sentKey) {
        try {
            if (sent == null || sent.getFirstWord() == null || !this.writer.setDoc(sentKey)) {
                return false;
            }
            this.writer.addRawSentence(sent);
            ArrayList cptList = this.cptExtractor.extractFromSentence(sent);
            if (this.writer.isRelationSupported()) {
                ArrayList tripleList = this.tripleExtractor.extractFromSentence(sent);
                this.writer.write(cptList, tripleList);
            } else {
                this.writer.write(cptList);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.writer.initialize();
        this.initialized = true;
    }

    public void close() {
        this.initialized = false;
        this.writer.close();
    }

    public OnlineSentenceBase getSentenceBase() {
        return this.writer.getSentenceBase();
    }

    public IRTermIndexList getTermIndexList() {
        return this.writer.getTermIndexList();
    }

    public IRRelationIndexList getRelationIndexList() {
        return this.writer.getRelationIndexList();
    }

    public IRDocIndexList getDocIndexList() {
        return this.writer.getDocIndexList();
    }

    public SimpleElementList getDocKeyList() {
        return this.writer.getDocKeyList();
    }

    public SimpleElementList getTermKeyList() {
        return this.writer.getTermKeyList();
    }

    public SimplePairList getRelationKeyList() {
        return this.writer.getRelationKeyList();
    }

    public IntSparseMatrix getDocTermMatrix() {
        return this.writer.getDocTermMatrix();
    }

    public IntSparseMatrix getDocRelationMatrix() {
        return this.writer.getDocRelationMatrix();
    }

    public IRCollection getIRCollection() {
        return this.writer.getIRCollection();
    }
}

