/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sentence;

import dragon.ir.index.AbstractIndexWriteController;
import dragon.ir.index.BasicIndexWriter;
import dragon.ir.index.FileIndex;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexWriter;
import dragon.nlp.Sentence;
import dragon.nlp.SimpleElementList;
import dragon.nlp.SimplePairList;
import dragon.onlinedb.BasicArticle;
import dragon.onlinedb.BasicCollectionWriter;
import java.util.ArrayList;

public class BasicSentenceWriteController
extends AbstractIndexWriteController {
    private IndexWriter indexWriter;
    private BasicCollectionWriter rawBW;
    private FileIndex fileIndex;

    public BasicSentenceWriteController(String directory, boolean relationSupported, boolean indexConceptEntry) {
        super(relationSupported, indexConceptEntry);
        this.fileIndex = new FileIndex(directory, relationSupported);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.docKeyList = new SimpleElementList(this.fileIndex.getDocKeyListFilename(), true);
        this.termKeyList = new SimpleElementList(this.fileIndex.getTermKeyListFilename(), true);
        if (this.relationSupported) {
            this.relationKeyList = new SimplePairList(this.fileIndex.getRelationKeyListFilename(), true);
        }
        this.indexWriter = new BasicIndexWriter(this.fileIndex.getDirectory(), this.relationSupported);
        this.indexWriter.initialize();
        this.initialized = true;
    }

    public void flush() {
        this.indexWriter.flush();
    }

    public void close() {
        try {
            this.docKeyList.close();
            this.termKeyList.close();
            if (this.relationSupported) {
                this.relationKeyList.close();
            }
            this.indexWriter.close();
            this.initialized = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean addRawSentence(Sentence sent) {
        try {
            BasicArticle article = new BasicArticle();
            article.setKey(this.curDocKey);
            article.setTitle(sent.toString());
            this.rawBW.add(article);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean write(ArrayList conceptList) {
        try {
            if (this.curDocKey == null) {
                return false;
            }
            IRDoc curDoc = new IRDoc(this.curDocKey);
            curDoc.setIndex(this.curDocIndex);
            IRTerm[] arrTerms = this.getIRTermArray(this.generateIRTermList(conceptList), curDoc);
            return this.indexWriter.write(curDoc, arrTerms);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean write(ArrayList conceptList, ArrayList tripleList) {
        try {
            if (this.curDocKey == null) {
                return false;
            }
            IRDoc curDoc = new IRDoc(this.curDocKey);
            curDoc.setIndex(this.curDocIndex);
            IRTerm[] arrTerms = this.getIRTermArray(this.generateIRTermList(conceptList), curDoc);
            IRRelation[] arrRelations = this.getIRRelationArray(this.generateIRRelationList(tripleList), curDoc);
            return this.indexWriter.write(curDoc, arrTerms, arrRelations);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

