/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sentence;

import dragon.ir.index.Indexer;
import dragon.nlp.Document;
import dragon.nlp.DocumentParser;
import dragon.nlp.Paragraph;
import dragon.nlp.Sentence;
import dragon.onlinedb.Article;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.PrintWriter;
import java.util.Date;

public abstract class AbstractSentenceIndexer
implements Indexer {
    protected boolean initialized;
    protected DocumentParser parser;
    private PrintWriter log;
    private SortedArray docs;
    private int minSentenceLength;
    private boolean useTitle;
    private boolean useAbstract;
    private boolean useBody;

    public AbstractSentenceIndexer(DocumentParser parser) {
        this.parser = parser;
        this.docs = new SortedArray();
        this.initialized = false;
        this.useTitle = true;
        this.useAbstract = true;
        this.useBody = true;
        this.initialized = false;
        this.minSentenceLength = 3;
    }

    public abstract boolean index(Sentence var1, String var2);

    public void setMinSentenceLength(int minLength) {
        if (minLength >= 1) {
            this.minSentenceLength = minLength;
        }
    }

    public int getMinSentenceLength() {
        return this.minSentenceLength;
    }

    public boolean screenArticleContent(boolean useTitle, boolean useAbstract, boolean useBody) {
        if (this.initialized) {
            return false;
        }
        this.useTitle = useTitle;
        this.useAbstract = useAbstract;
        this.useBody = useBody;
        return true;
    }

    public void setLog(String logFile) {
        this.log = FileUtil.getPrintWriter(logFile);
    }

    public boolean indexed(String docKey) {
        return this.docs.contains(docKey);
    }

    public synchronized boolean index(Article article) {
        try {
            if (!this.initialized) {
                System.out.println("Please initialize the indexer before indexing!");
                return false;
            }
            if (article.getKey() == null || this.docs.contains(article.getKey())) {
                return false;
            }
            Document doc = this.getDocument(article);
            if (doc == null) {
                return false;
            }
            int index = -1;
            this.docs.add(article.getKey());
            Paragraph para = doc.getFirstParagraph();
            while (para != null) {
                Sentence sent = para.getFirstSentence();
                while (sent != null) {
                    if (sent.getWordNum() >= this.minSentenceLength) {
                        String sentKey = this.getSentenceKey(article.getKey(), ++index);
                        if (this.index(sent, sentKey)) {
                            this.writeLog(new Date().toString() + " " + sentKey + " successful");
                        } else {
                            this.writeLog(new Date().toString() + " " + sentKey + " failed");
                        }
                    }
                    sent = sent.next;
                }
                para = para.next;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Document getDocument(Article article) {
        if (article.getKey() == null || article.getKey().trim().length() == 0) {
            return null;
        }
        Document doc = new Document();
        if (this.useTitle) {
            doc.addParagraph(this.parser.parseParagraph(article.getTitle()));
        }
        if (this.useAbstract) {
            doc.addParagraph(this.parser.parseParagraph(article.getAbstract()));
        }
        if (this.useBody && article.getBody() != null) {
            doc.addParagraph(this.parser.parseParagraph(article.getBody()));
        }
        if (doc.getFirstParagraph() != null) {
            return doc;
        }
        return null;
    }

    protected String getSentenceKey(String docKey, int sentIndex) {
        return docKey + "_" + sentIndex;
    }

    protected void writeLog(String content) {
        if (this.log != null) {
            this.log.write(content);
            this.log.flush();
        }
    }

    public void close() {
        if (this.log != null) {
            this.log.close();
        }
        this.initialized = false;
    }
}

