/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.AbstractIndexReader;
import dragon.ir.index.Indexer;
import dragon.ir.index.OnlineIndexer;
import dragon.matrix.IntSparseMatrix;
import dragon.onlinedb.Article;
import dragon.onlinedb.CollectionReader;

public class OnlineIndexReader
extends AbstractIndexReader {
    protected OnlineIndexer indexer;

    public OnlineIndexReader(OnlineIndexer indexer) {
        this(indexer, null);
    }

    public OnlineIndexReader(OnlineIndexer indexer, CollectionReader collectionReader) {
        super(indexer.isRelationSupported(), collectionReader);
        this.indexer = indexer;
    }

    public void initialize() {
        if (this.initialized || this.collectionReader == null) {
            return;
        }
        this.indexer.initialize();
        if (!this.index(this.indexer, this.collectionReader)) {
            System.out.println("Failed to index articles!");
            return;
        }
        this.indexer.close();
        this.collection = this.indexer.getIRCollection();
        this.docIndexList = this.indexer.getDocIndexList();
        this.docKeyList = this.indexer.getDocKeyList();
        this.termIndexList = this.indexer.getTermIndexList();
        this.termKeyList = this.indexer.getTermKeyList();
        this.doctermMatrix = this.indexer.getDocTermMatrix();
        this.doctermMatrix.finalizeData();
        this.termdocMatrix = (IntSparseMatrix)this.doctermMatrix.transpose();
        if (this.relationSupported) {
            this.relationIndexList = this.indexer.getRelationIndexList();
            this.docrelationMatrix = this.indexer.getDocRelationMatrix();
            this.docrelationMatrix.finalizeData();
            this.relationdocMatrix = (IntSparseMatrix)this.docrelationMatrix.transpose();
        }
        this.initialized = true;
    }

    public void setCollectionReader(CollectionReader collectionReader) {
        this.initialized = false;
        this.collectionReader = collectionReader;
    }

    protected boolean index(Indexer indexer, CollectionReader collectionReader) {
        try {
            Article article = collectionReader.getNextArticle();
            while (article != null) {
                if (!indexer.indexed(article.getKey())) {
                    indexer.index(article);
                }
                article = collectionReader.getNextArticle();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

