/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IRSection;
import dragon.ir.index.Indexer;
import dragon.onlinedb.Article;
import dragon.util.FileUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public abstract class AbstractIndexer
implements Indexer {
    private PrintWriter log = null;
    protected IRSection[] arrSections;
    protected boolean relationSupported;
    protected boolean initialized;
    protected boolean enable_AllSection;
    private ArrayList sectionList;
    private ArrayList conceptList;
    private ArrayList relationList;
    private ArrayList sectionConceptList;
    private ArrayList sectionRelationList;

    public AbstractIndexer(boolean relationSupported) {
        this.relationSupported = relationSupported;
        this.initialized = false;
        this.sectionList = new ArrayList();
        this.conceptList = new ArrayList();
        this.relationList = new ArrayList();
        this.sectionConceptList = new ArrayList();
        this.sectionRelationList = new ArrayList();
    }

    protected abstract void initDocIndexing();

    protected abstract String getRemainingSections(Article var1);

    protected abstract boolean extract(String var1, ArrayList var2);

    protected abstract boolean extract(String var1, ArrayList var2, ArrayList var3);

    protected abstract boolean setDoc(String var1);

    protected abstract void initSectionWrite(IRSection var1);

    protected abstract void initIndex();

    protected abstract void write(int var1, ArrayList var2);

    protected abstract void write(int var1, ArrayList var2, ArrayList var3);

    public void setLog(String logFile) {
        this.log = FileUtil.getPrintWriter(logFile);
    }

    protected boolean addSection(IRSection section) {
        if (this.initialized) {
            return false;
        }
        int i = 0;
        while (i < this.sectionList.size()) {
            IRSection cur = (IRSection)this.sectionList.get(i);
            if (cur.getSectionID() == section.getSectionID()) {
                return false;
            }
            if (cur.getSectionName().equalsIgnoreCase(section.getSectionName())) {
                return false;
            }
            ++i;
        }
        this.sectionList.add(section);
        return true;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.arrSections = new IRSection[this.sectionList.size()];
        Collections.sort(this.sectionList);
        int i = 0;
        while (i < this.sectionList.size()) {
            IRSection cur;
            this.arrSections[i] = cur = (IRSection)this.sectionList.get(i);
            if (cur.getSectionID() == 0) {
                this.enable_AllSection = true;
            }
            this.initSectionWrite(cur);
            ++i;
        }
        this.initIndex();
        this.initialized = true;
    }

    public boolean index(Article article) {
        try {
            if (!this.initialized) {
                return false;
            }
            this.writeLog(new Date().toString());
            this.writeLog("Indexing article #" + article.getKey() + ": ");
            this.conceptList.clear();
            this.relationList.clear();
            this.initDocIndexing();
            if (!this.setDoc(article.getKey())) {
                this.writeLog("indexed\n");
                return false;
            }
            int i = this.enable_AllSection ? 1 : 0;
            boolean ret = true;
            while (i < this.arrSections.length) {
                this.sectionConceptList.clear();
                this.sectionRelationList.clear();
                int sectionID = this.arrSections[i].getSectionID();
                if (this.relationSupported) {
                    ret = this.extract(this.getSection(article, sectionID), this.sectionConceptList, this.sectionRelationList);
                    this.write(sectionID, this.sectionConceptList, this.sectionRelationList);
                    if (this.enable_AllSection) {
                        this.conceptList.addAll(this.sectionConceptList);
                        this.relationList.addAll(this.sectionRelationList);
                    }
                } else {
                    ret = this.extract(this.getSection(article, sectionID), this.sectionConceptList);
                    this.write(sectionID, this.sectionConceptList);
                    if (this.enable_AllSection) {
                        this.conceptList.addAll(this.sectionConceptList);
                    }
                }
                if (!ret) break;
                ++i;
            }
            if (this.enable_AllSection && ret) {
                this.sectionConceptList.clear();
                this.sectionRelationList.clear();
                if (this.relationSupported) {
                    ret = this.extract(this.getRemainingSections(article), this.sectionConceptList, this.sectionRelationList);
                    this.conceptList.addAll(this.sectionConceptList);
                    this.relationList.addAll(this.sectionRelationList);
                    this.write(0, this.conceptList, this.relationList);
                } else {
                    ret = this.extract(this.getRemainingSections(article), this.sectionConceptList);
                    this.conceptList.addAll(this.sectionConceptList);
                    this.write(0, this.conceptList);
                }
            }
            if (ret) {
                this.writeLog("succeeded\r\n");
                return true;
            }
            this.writeLog("failed\r\n");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeLog("failed\r\n");
            return false;
        }
    }

    protected String getSection(Article paper, int sectionID) {
        switch (sectionID) {
            case 1: {
                return paper.getTitle();
            }
            case 2: {
                return paper.getAbstract();
            }
            case 3: {
                return paper.getBody();
            }
            case 4: {
                return paper.getMeta();
            }
        }
        return null;
    }

    protected void writeLog(String content) {
        if (this.log != null) {
            this.log.write(content);
            this.log.flush();
        }
    }
}

