/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.featurefilter;

import dragon.ir.clustering.featurefilter.AbstractFeatureFilter;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.util.MathUtil;
import java.util.ArrayList;

public class DocFrequencyFilter
extends AbstractFeatureFilter {
    private int minDocFrequency;

    public DocFrequencyFilter(int minDocFrequency) {
        this.minDocFrequency = minDocFrequency;
    }

    protected int[] getSelectedFeatures(IndexReader indexReader, IRDoc[] docSet) {
        int termNum = indexReader.getCollection().getTermNum();
        int[] arrDocFreq = docSet != null && (double)docSet.length < (double)indexReader.getCollection().getDocNum() * 0.67 ? this.computeTermCount(indexReader, docSet) : null;
        ArrayList<IRTerm> list2 = new ArrayList<IRTerm>(termNum);
        int i = 0;
        while (i < termNum) {
            IRTerm curTerm;
            if ((arrDocFreq == null || arrDocFreq[i] != 0) && (curTerm = indexReader.getIRTerm(i)).getDocFrequency() >= this.minDocFrequency) {
                list2.add(curTerm);
            }
            ++i;
        }
        int[] featureMap = new int[list2.size()];
        i = 0;
        while (i < featureMap.length) {
            featureMap[i] = ((IRTerm)list2.get(i)).getIndex();
            ++i;
        }
        return featureMap;
    }

    private int[] computeTermCount(IndexReader indexReader, IRDoc[] arrDoc) {
        int[] buf = new int[indexReader.getCollection().getTermNum()];
        MathUtil.initArray(buf, 0);
        int j = 0;
        while (j < arrDoc.length) {
            int[] arrIndex = indexReader.getTermIndexList(arrDoc[j].getIndex());
            int k = 0;
            while (k < arrIndex.length) {
                int n = arrIndex[k];
                buf[n] = buf[n] + 1;
                ++k;
            }
            ++j;
        }
        return buf;
    }
}

