/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.featurefilter;

import dragon.ir.clustering.featurefilter.FeatureFilter;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.util.MathUtil;

public abstract class AbstractFeatureFilter
implements FeatureFilter {
    protected int[] featureMap;
    protected int selectedFeatureNum;

    protected abstract int[] getSelectedFeatures(IndexReader var1, IRDoc[] var2);

    public void initialize(IndexReader indexReader, IRDoc[] docSet) {
        this.setSelectedFeatures(this.getSelectedFeatures(indexReader, docSet));
    }

    protected void setSelectedFeatures(int[] selectedFeatures) {
        if (selectedFeatures == null) {
            return;
        }
        int oldFeatureNum = selectedFeatures[selectedFeatures.length - 1] + 1;
        this.featureMap = new int[oldFeatureNum];
        MathUtil.initArray(this.featureMap, -1);
        int i = 0;
        while (i < selectedFeatures.length) {
            this.featureMap[selectedFeatures[i]] = i;
            ++i;
        }
        this.selectedFeatureNum = selectedFeatures.length;
    }

    public boolean isSelected(int originalFeatureIndex) {
        if (originalFeatureIndex >= this.featureMap.length) {
            return false;
        }
        return this.featureMap[originalFeatureIndex] != -1;
    }

    public int map(int originalFeatureIndex) {
        if (originalFeatureIndex >= this.featureMap.length) {
            return -1;
        }
        return this.featureMap[originalFeatureIndex];
    }

    public int getSelectedFeatureNum() {
        return this.selectedFeatureNum;
    }
}

