/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.docdistance;

import dragon.ir.clustering.docdistance.AbstractDocDistance;
import dragon.ir.index.IRDoc;
import dragon.matrix.SparseMatrix;

public class CosineDocDistance
extends AbstractDocDistance {
    public CosineDocDistance(SparseMatrix doctermMatrix) {
        super(doctermMatrix);
    }

    public double getDistance(IRDoc first, IRDoc second) {
        double[] firstScoreList = this.matrix.getNonZeroDoubleScoresInRow(first.getIndex());
        double[] secondScoreList = this.matrix.getNonZeroDoubleScoresInRow(second.getIndex());
        int[] firstIndexList = this.matrix.getNonZeroColumnsInRow(first.getIndex());
        int[] secondIndexList = this.matrix.getNonZeroColumnsInRow(second.getIndex());
        return 1.0 - this.cosine(firstIndexList, firstScoreList, secondIndexList, secondScoreList);
    }

    private double cosine(int[] arrXCol, double[] arrXScore, int[] arrYCol, double[] arrYScore) {
        if (arrXCol == null || arrYCol == null) {
            return 0.0;
        }
        int xNum = arrXCol.length;
        int yNum = arrYCol.length;
        if (xNum == 0 || yNum == 0) {
            return 0.0;
        }
        int x2 = 0;
        int y = 0;
        double xy = 0.0;
        double x22 = 0.0;
        double y2 = 0.0;
        while (x2 < xNum && y < yNum) {
            if (arrXCol[x2] < arrYCol[y]) {
                if (this.featureFilter == null || this.featureFilter.map(arrXCol[x2]) >= 0) {
                    x22 += arrXScore[x2] * arrXScore[x2];
                }
                ++x2;
                continue;
            }
            if (arrXCol[x2] == arrYCol[y]) {
                if (this.featureFilter == null || this.featureFilter.map(arrXCol[x2]) >= 0) {
                    xy += arrXScore[x2] * arrYScore[y];
                    x22 += arrXScore[x2] * arrXScore[x2];
                    y2 += arrYScore[y] * arrYScore[y];
                }
                ++x2;
                ++y;
                continue;
            }
            if (this.featureFilter == null || this.featureFilter.map(arrYCol[y]) >= 0) {
                y2 += arrYScore[y] * arrYScore[y];
            }
            ++y;
        }
        while (y < yNum) {
            if (this.featureFilter == null || this.featureFilter.map(arrYCol[y]) >= 0) {
                y2 += arrYScore[y] * arrYScore[y];
            }
            ++y;
        }
        while (x2 < xNum) {
            if (this.featureFilter == null || this.featureFilter.map(arrXCol[x2]) >= 0) {
                x22 += arrXScore[x2] * arrXScore[x2];
            }
            ++x2;
        }
        return xy / (Math.sqrt(x22) * Math.sqrt(y2));
    }
}

