/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.clustermodel;

import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.clustermodel.AbstractClusterModel;
import dragon.ir.index.IRDoc;
import dragon.matrix.SparseMatrix;

public class EuclideanClusterModel
extends AbstractClusterModel {
    private double[][] arrClusterVector;
    private double[] arrClusterVectorLen;
    private SparseMatrix matrix;

    public EuclideanClusterModel(int clusterNum, SparseMatrix docTerm) {
        super(clusterNum);
        this.arrClusterVectorLen = new double[clusterNum];
        this.matrix = docTerm;
    }

    public void setClusterNum(int clusterNum) {
        this.clusterNum = clusterNum;
        this.arrClusterVectorLen = new double[clusterNum];
    }

    public void setDocCluster(DocCluster cluster) {
        int featureNum = this.featureFilter == null ? this.matrix.columns() : this.featureFilter.getSelectedFeatureNum();
        if (this.arrClusterVector == null || this.arrClusterVector.length != this.clusterNum || this.arrClusterVector[0].length != featureNum) {
            this.arrClusterVector = new double[this.clusterNum][featureNum];
        }
        int clusterID = cluster.getClusterID();
        int i = 0;
        while (i < cluster.getDocNum()) {
            int[] indexList = this.matrix.getNonZeroColumnsInRow(cluster.getDoc(i).getIndex());
            double[] freqList = this.matrix.getNonZeroDoubleScoresInRow(cluster.getDoc(i).getIndex());
            int j = 0;
            while (j < indexList.length) {
                int newIndex = indexList[j];
                if (this.featureFilter != null) {
                    newIndex = this.featureFilter.map(newIndex);
                }
                if (newIndex >= 0) {
                    double[] dArray = this.arrClusterVector[clusterID];
                    int n = newIndex;
                    dArray[n] = dArray[n] + freqList[j];
                }
                ++j;
            }
            ++i;
        }
        this.arrClusterVectorLen[clusterID] = 0.0;
        i = 0;
        while (i < this.arrClusterVector[clusterID].length) {
            if (this.arrClusterVector[clusterID][i] != 0.0) {
                this.arrClusterVector[clusterID][i] = this.arrClusterVector[clusterID][i] / (double)cluster.getDocNum();
                int n = clusterID;
                this.arrClusterVectorLen[n] = this.arrClusterVectorLen[n] + this.arrClusterVector[clusterID][i] * this.arrClusterVector[clusterID][i];
            }
            ++i;
        }
    }

    public double getDistance(IRDoc doc, int clusterID) {
        double product2 = this.arrClusterVectorLen[clusterID];
        int[] indexList = this.matrix.getNonZeroColumnsInRow(doc.getIndex());
        double[] freqList = this.matrix.getNonZeroDoubleScoresInRow(doc.getIndex());
        int i = 0;
        while (i < indexList.length) {
            int newIndex = indexList[i];
            if (this.featureFilter != null) {
                newIndex = this.featureFilter.map(newIndex);
            }
            if (newIndex >= 0) {
                product2 += freqList[i] * (freqList[i] - 2.0 * this.arrClusterVector[clusterID][newIndex]);
            }
            ++i;
        }
        return Math.sqrt(product2);
    }
}

