/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering;

import dragon.ir.clustering.AbstractClustering;
import dragon.ir.clustering.Clustering;
import dragon.ir.clustering.clustermodel.ClusterModel;
import dragon.ir.clustering.clustermodel.MultinomialClusterModel;
import dragon.ir.index.IRDoc;
import dragon.matrix.DoubleDenseMatrix;
import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.matrix.SparseMatrix;
import dragon.matrix.vector.DoubleVector;
import dragon.util.MathUtil;
import java.util.Date;

public class LinkKMean
extends AbstractClustering {
    private Clustering initClustering;
    private SparseMatrix inLinks;
    private SparseMatrix outLinks;
    private ClusterModel distMetric;
    private int maxIteration;
    private boolean useWeight;

    public LinkKMean(Clustering initClustering, SparseMatrix links) {
        this(initClustering, links, null);
    }

    public LinkKMean(Clustering initClustering, SparseMatrix outLinks, SparseMatrix inLinks) {
        super(initClustering.getIndexReader());
        this.initClustering = initClustering;
        this.inLinks = inLinks;
        this.outLinks = outLinks;
        this.clusterNum = initClustering.getClusterNum();
        this.distMetric = new MultinomialClusterModel(this.clusterNum, this.indexReader, 0.5);
    }

    public void setUseWeight(boolean useWeight) {
        this.useWeight = useWeight;
    }

    public boolean getUseWeight() {
        return this.useWeight;
    }

    protected boolean initialize(IRDoc[] arrDoc) {
        this.initClustering.setRandomSeed(this.randomSeed);
        this.initClustering.cluster(arrDoc);
        this.distMetric.setFeatureFilter(this.initClustering.getFeatureFilter());
        this.clusterSet = this.initClustering.getClusterSet();
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean cluster(IRDoc[] arrDoc) {
        probVector = new DoubleVector(this.clusterNum);
        movingObj = arrDoc.length;
        iteration = 0;
        arrDocLabel = new int[this.indexReader.getCollection().getDocNum()];
        outNeighbor = new double[this.clusterNum];
        inNeighbor = this.inLinks != null ? new double[this.clusterNum] : null;
        if (this.initialize(arrDoc)) ** GOTO lbl71
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.showProgress) {
                System.out.print(new Date().toString() + " " + iteration++);
                System.out.print(" ");
                System.out.println(movingObj);
            }
            this.distMetric.setDocClusters(this.clusterSet);
            MathUtil.initArray(arrDocLabel, -1);
            i = 0;
            while (i < arrDoc.length) {
                arrDocLabel[arrDoc[i].getIndex()] = arrDoc[i].getCategory();
                ++i;
            }
            transMatrix = this.estimateClassTransferProb(arrDoc, arrDocLabel);
            movingObj = 0;
            i = 0;
            while (i < arrDoc.length) {
                MathUtil.initArray(outNeighbor, 0.0);
                arrIndex = this.outLinks.getNonZeroColumnsInRow(arrDoc[i].getIndex());
                arrScore /* !! */  = this.useWeight != false ? this.outLinks.getNonZeroDoubleScoresInRow(arrDoc[i].getIndex()) : null;
                if (arrIndex != null) {
                    j = 0;
                    while (j < arrIndex.length) {
                        label = arrDocLabel[arrIndex[j]];
                        if (label >= 0) {
                            if (!this.useWeight) {
                                v0 = label;
                                outNeighbor[v0] = outNeighbor[v0] + 1.0;
                            } else {
                                v1 = label;
                                outNeighbor[v1] = outNeighbor[v1] + arrScore /* !! */ [j];
                            }
                        }
                        ++j;
                    }
                }
                if (this.inLinks != null) {
                    MathUtil.initArray(inNeighbor, 0.0);
                    arrIndex = this.inLinks.getNonZeroColumnsInRow(arrDoc[i].getIndex());
                    arrScore /* !! */  = (double[])(this.useWeight != false ? this.inLinks.getNonZeroDoubleScoresInRow(arrDoc[i].getIndex()) : null);
                    if (arrIndex != null) {
                        j = 0;
                        while (j < arrIndex.length) {
                            label = arrDocLabel[arrIndex[j]];
                            if (label >= 0) {
                                if (!this.useWeight) {
                                    v2 = label;
                                    inNeighbor[v2] = inNeighbor[v2] + 1.0;
                                } else {
                                    v3 = label;
                                    inNeighbor[v3] = inNeighbor[v3] + arrScore /* !! */ [j];
                                }
                            }
                            ++j;
                        }
                    }
                }
                j = 0;
                while (j < this.clusterNum) {
                    probVector.set(j, this.getLogLikelihood(arrDoc[i], j, transMatrix, outNeighbor, inNeighbor));
                    ++j;
                }
                curCluster = probVector.getDimWithMaxValue();
                if (curCluster != (oldCluster = arrDoc[i].getCategory())) {
                    this.clusterSet.removeDoc(oldCluster, arrDoc[i]);
                    this.clusterSet.addDoc(curCluster, arrDoc[i]);
                    ++movingObj;
                }
                ++i;
            }
lbl71:
            // 2 sources

            ** while (movingObj > 0 && iteration < this.maxIteration)
        }
lbl72:
        // 1 sources

        return true;
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public void setMaxIteration(int iteration) {
        this.maxIteration = iteration;
    }

    protected double getLogLikelihood(IRDoc doc, int clusterID, DoubleDenseMatrix transMatrix, double[] arrOutLinks, double[] arrInLinks) {
        double sum2 = -this.distMetric.getDistance(doc, clusterID);
        int i = 0;
        while (i < this.clusterNum) {
            sum2 += arrOutLinks[i] * transMatrix.getDouble(clusterID, i);
            ++i;
        }
        if (arrInLinks != null) {
            i = 0;
            while (i < this.clusterNum) {
                sum2 += arrInLinks[i] * transMatrix.getDouble(i, clusterID);
                ++i;
            }
        }
        return sum2;
    }

    protected DoubleDenseMatrix estimateClassTransferProb(IRDoc[] arrDoc, int[] arrDocLabel) {
        int j;
        DoubleFlatDenseMatrix matrix = new DoubleFlatDenseMatrix(this.clusterNum, this.clusterNum);
        matrix.assign(1.0);
        int i = 0;
        while (i < arrDoc.length) {
            int startLabel = arrDocLabel[arrDoc[i].getIndex()];
            int[] arrIndex = this.outLinks.getNonZeroColumnsInRow(arrDoc[i].getIndex());
            if (arrIndex != null) {
                double[] arrScore = this.useWeight ? this.outLinks.getNonZeroDoubleScoresInRow(arrDoc[i].getIndex()) : null;
                j = 0;
                while (j < arrIndex.length) {
                    int endLabel = arrDocLabel[arrIndex[j]];
                    if (endLabel >= 0) {
                        if (!this.useWeight) {
                            matrix.add(startLabel, endLabel, 1.0);
                        } else {
                            matrix.add(startLabel, endLabel, arrScore[j]);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.clusterNum) {
            double sum2 = matrix.getRowSum(i);
            j = 0;
            while (j < this.clusterNum) {
                matrix.setDouble(i, j, Math.log(matrix.getDouble(i, j) / sum2));
                ++j;
            }
            ++i;
        }
        return matrix;
    }
}

