/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering;

import dragon.ir.clustering.AbstractClustering;
import dragon.ir.clustering.BasicKMean;
import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.DocClusterSet;
import dragon.ir.clustering.clustermodel.ClusterModel;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;

public class BisectKMean
extends AbstractClustering {
    protected ClusterModel distMetric;
    protected boolean refine;
    protected int maxIteration;
    protected DocClusterSet clusterSet;
    private boolean initAllObjs;

    public BisectKMean(IndexReader indexReader, ClusterModel distMetric, int clusterNum) {
        this(indexReader, distMetric, clusterNum, false);
    }

    public BisectKMean(IndexReader indexReader, ClusterModel distMetric, int clusterNum, boolean initAllObjs) {
        super(indexReader);
        this.clusterNum = clusterNum;
        this.distMetric = distMetric;
        this.refine = false;
        this.maxIteration = 200;
        this.randomSeed = 0L;
        this.initAllObjs = initAllObjs;
    }

    public void setUseAllObjectForInitialization(boolean option) {
        this.initAllObjs = option;
    }

    public boolean getUseAllObjectForInitialization() {
        return this.initAllObjs;
    }

    public boolean cluster(IRDoc[] arrDoc) {
        if (this.featureFilter != null) {
            this.featureFilter.initialize(this.indexReader, arrDoc);
            this.distMetric.setFeatureFilter(this.featureFilter);
        }
        return this.cluster(arrDoc, 2);
    }

    public void setRefine(boolean refine) {
        this.refine = refine;
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public void setMaxIteration(int iteration) {
        this.maxIteration = iteration;
    }

    private boolean cluster(IRDoc[] arrDoc, int secNum) {
        if (this.clusterNum < secNum) {
            return false;
        }
        this.distMetric.setClusterNum(secNum);
        BasicKMean bkm = new BasicKMean(this.indexReader, this.distMetric, secNum, this.initAllObjs);
        bkm.setFeatureFilter(this.featureFilter);
        bkm.setMaxIteration(this.maxIteration);
        bkm.setRandomSeed(this.randomSeed);
        bkm.setShowProgress(this.showProgress);
        int id = 0;
        DocClusterSet mainDcs = new DocClusterSet(this.clusterNum);
        bkm.cluster(arrDoc);
        DocClusterSet dcs = bkm.getClusterSet();
        int i = 0;
        while (i < secNum) {
            mainDcs.setDocCluster(dcs.getDocCluster(i), id++);
            ++i;
        }
        while (id < this.clusterNum) {
            DocCluster dc;
            int max2 = Integer.MIN_VALUE;
            int index = -1;
            i = 0;
            while (i < id) {
                dc = mainDcs.getDocCluster(i);
                if (max2 < dc.getDocNum()) {
                    max2 = dc.getDocNum();
                    index = i;
                }
                ++i;
            }
            dc = mainDcs.getDocCluster(index);
            arrDoc = new IRDoc[dc.getDocNum()];
            i = 0;
            while (i < dc.getDocNum()) {
                arrDoc[i] = dc.getDoc(i);
                arrDoc[i].setCategory(-1);
                ++i;
            }
            this.distMetric.setClusterNum(secNum);
            bkm = new BasicKMean(this.indexReader, this.distMetric, secNum, this.initAllObjs);
            bkm.setMaxIteration(this.maxIteration);
            bkm.setRandomSeed(this.randomSeed);
            bkm.setShowProgress(this.showProgress);
            bkm.cluster(arrDoc);
            mainDcs.setDocCluster(bkm.getClusterSet().getDocCluster(0), index);
            i = 1;
            while (i < bkm.getClusterNum()) {
                mainDcs.setDocCluster(bkm.getClusterSet().getDocCluster(i), id++);
                ++i;
            }
        }
        if (this.refine) {
            this.distMetric.setClusterNum(this.clusterNum);
            bkm = new BasicKMean(this.indexReader, this.distMetric, mainDcs);
            bkm.setMaxIteration(this.maxIteration);
            bkm.setRandomSeed(this.randomSeed);
            bkm.setShowProgress(this.showProgress);
            arrDoc = new IRDoc[this.indexReader.getCollection().getDocNum()];
            bkm.cluster(arrDoc);
        }
        this.clusterSet = mainDcs;
        return true;
    }

    public DocClusterSet getClusterSet() {
        return this.clusterSet;
    }
}

