/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering;

import dragon.ir.clustering.AbstractClustering;
import dragon.ir.clustering.DocClusterSet;
import dragon.ir.clustering.clustermodel.ClusterModel;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import java.util.Date;
import java.util.Random;

public class BasicKMean
extends AbstractClustering {
    protected ClusterModel distMetric;
    protected boolean initialized;
    protected int maxIteration;
    private boolean initAllObjs;

    public BasicKMean(IndexReader indexReader, ClusterModel distMetric, int clusterNum) {
        this(indexReader, distMetric, clusterNum, false);
    }

    public BasicKMean(IndexReader indexReader, ClusterModel distMetric, int clusterNum, boolean initAllObjs) {
        super(indexReader);
        this.clusterNum = clusterNum;
        this.distMetric = distMetric;
        this.initialized = false;
        this.maxIteration = 200;
        this.randomSeed = 0L;
        this.initAllObjs = initAllObjs;
    }

    public BasicKMean(IndexReader indexReader, ClusterModel distMetric, DocClusterSet initClusterSet) {
        super(indexReader);
        this.clusterNum = initClusterSet.getClusterNum();
        this.distMetric = distMetric;
        this.clusterSet = initClusterSet;
        distMetric.setDocClusters(initClusterSet);
        this.initialized = true;
        this.maxIteration = 200;
    }

    public void setUseAllObjectForInitialization(boolean option) {
        this.initAllObjs = option;
    }

    public boolean getUseAllObjectForInitialization() {
        return this.initAllObjs;
    }

    protected boolean initialize(IRDoc[] arrDoc) {
        Random random = new Random();
        if (this.randomSeed > 0L) {
            random.setSeed(this.randomSeed);
        }
        this.clusterSet = new DocClusterSet(this.clusterNum);
        int i = 0;
        while (i < arrDoc.length) {
            arrDoc[i].setCategory(-1);
            ++i;
        }
        i = 0;
        while (i < this.clusterNum) {
            int curDocNo = (int)(random.nextDouble() * (double)arrDoc.length);
            if (arrDoc[curDocNo].getCategory() != -1) continue;
            this.clusterSet.addDoc(i, arrDoc[curDocNo]);
            ++i;
        }
        i = 0;
        while (this.initAllObjs && i < arrDoc.length) {
            if (arrDoc[i].getCategory() == -1) {
                this.clusterSet.addDoc(random.nextInt(this.clusterNum), arrDoc[i]);
            }
            ++i;
        }
        this.distMetric.setDocClusters(this.clusterSet);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean cluster(IRDoc[] arrDoc) {
        if (this.featureFilter != null) {
            this.featureFilter.initialize(this.indexReader, arrDoc);
            this.distMetric.setFeatureFilter(this.featureFilter);
        }
        random = new Random();
        if (this.randomSeed > 0L) {
            random.setSeed(this.randomSeed);
        }
        arrCanCluster = new int[this.clusterNum];
        movingObj = docNum = arrDoc.length;
        iteration = 0;
        if (this.initialized || this.initialize(arrDoc)) ** GOTO lbl47
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.showProgress) {
                System.out.print(new Date().toString() + " " + iteration++);
                System.out.print(" ");
                System.out.println(movingObj);
            }
            movingObj = 0;
            i = 0;
            while (i < docNum) {
                minDist = 1.7976931348623157E308;
                candidateNum = 0;
                j = 0;
                while (j < this.clusterNum) {
                    curDist = this.distMetric.getDistance(arrDoc[i], j);
                    if (curDist <= minDist - 1.0E-5) {
                        minDist = curDist;
                        arrCanCluster[0] = j;
                        candidateNum = 1;
                    } else if (Math.abs(curDist - minDist) < 1.0E-5) {
                        if (curDist < minDist) {
                            minDist = curDist;
                        }
                        arrCanCluster[candidateNum] = j;
                        ++candidateNum;
                    }
                    ++j;
                }
                curCluster = candidateNum == 1 ? arrCanCluster[0] : ((curCluster = (int)(random.nextDouble() * (double)candidateNum)) == candidateNum ? arrCanCluster[curCluster - 1] : arrCanCluster[curCluster]);
                if (curCluster != (oldCluster = arrDoc[i].getCategory())) {
                    this.clusterSet.removeDoc(arrDoc[i].getCategory(), arrDoc[i]);
                    this.clusterSet.addDoc(curCluster, arrDoc[i]);
                    ++movingObj;
                }
                ++i;
            }
            if (movingObj == 0) break;
            this.distMetric.setDocClusters(this.clusterSet);
lbl47:
            // 2 sources

            ** while (movingObj > 0 && iteration < this.maxIteration)
        }
lbl48:
        // 2 sources

        return true;
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public void setMaxIteration(int iteration) {
        this.maxIteration = iteration;
    }
}

