/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.SparseMatrixConfig;
import dragon.ir.index.BasicIRTermIndexList;
import dragon.ir.index.IRSignatureIndexList;
import dragon.ir.kngbase.TopicSignatureModel;
import dragon.matrix.IntGiantSparseMatrix;
import dragon.matrix.IntSparseMatrix;
import dragon.matrix.IntSuperSparseMatrix;

public class TranslationAppConfig {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please input two parameters: configuration xml file and translation applicaiton id");
            return;
        }
        ConfigUtil util = new ConfigUtil();
        BasicConfigureNode root2 = new BasicConfigureNode(args[0]);
        ConfigureNode transAppNode = util.getConfigureNode(root2, "translationapp", Integer.parseInt(args[1]));
        if (transAppNode == null) {
            return;
        }
        TranslationAppConfig transApp = new TranslationAppConfig();
        transApp.translate(transAppNode);
    }

    public void translate(ConfigureNode transNode) {
        String indexSection = transNode.getString("indexsection", "all");
        String srcIndexFolder = transNode.getString("srcindexfolder");
        String destIndexFolder = transNode.getString("destindexfolder", srcIndexFolder);
        srcIndexFolder = srcIndexFolder + "/" + indexSection;
        destIndexFolder = destIndexFolder + "/" + indexSection;
        String transMatrixKey = transNode.getString("translationmatrixkey");
        boolean relation = transNode.getBoolean("relation", false);
        boolean useEM = transNode.getBoolean("useem", true);
        boolean useDocFreq = transNode.getBoolean("usedocfrequency", true);
        boolean useMeanTrim = transNode.getBoolean("usemeantrim", false);
        int minFrequency = transNode.getInt("minfrequency", 2);
        double emBkgCoefficient = transNode.getDouble("embkgcoefficient", 0.5);
        double probThreshold = transNode.getDouble("probthreshold", 0.001);
        int matrixID = transNode.getInt("cooccurrencematrix");
        IntSparseMatrix cooccurMatrix = matrixID > 0 ? new SparseMatrixConfig().getIntSparseMatrix(transNode, matrixID) : null;
        this.translate(cooccurMatrix, srcIndexFolder, relation, minFrequency, destIndexFolder, transMatrixKey, useEM, useDocFreq, useMeanTrim, probThreshold, emBkgCoefficient);
    }

    public void translate(IntSparseMatrix cooccurMatrix, String srcIndexFolder, boolean relation, int minFrequency, String destIndexFolder, String matrixKey, boolean useEM, boolean useDocFreq, boolean useMeanTrim, double probThreshold, double emBkgCoefficient) {
        TopicSignatureModel model;
        BasicIRTermIndexList srcIndexList = relation ? new BasicIRTermIndexList(srcIndexFolder + "/relationindex.list", false) : new BasicIRTermIndexList(srcIndexFolder + "/termindex.list", false);
        BasicIRTermIndexList destIndexList = useEM ? new BasicIRTermIndexList(destIndexFolder + "/termindex.list", false) : null;
        if (cooccurMatrix == null) {
            IntGiantSparseMatrix srcMatrix = relation ? new IntGiantSparseMatrix(srcIndexFolder + "/relationdoc.index", srcIndexFolder + "/relationdoc.matrix") : new IntGiantSparseMatrix(srcIndexFolder + "/termdoc.index", srcIndexFolder + "/termdoc.matrix");
            IntSuperSparseMatrix destMatrix = new IntSuperSparseMatrix(destIndexFolder + "/docterm.index", destIndexFolder + "/docterm.matrix");
            model = new TopicSignatureModel(srcIndexList, srcMatrix, destIndexList, destMatrix);
        } else {
            model = new TopicSignatureModel((IRSignatureIndexList)srcIndexList, destIndexList, cooccurMatrix);
        }
        model.setUseDocFrequency(useDocFreq);
        model.setUseEM(useEM);
        model.setUseMeanTrim(useMeanTrim);
        model.setProbThreshold(probThreshold);
        model.setEMBackgroundCoefficient(emBkgCoefficient);
        model.genTransMatrix(minFrequency, destIndexFolder, matrixKey);
    }
}

