/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.IndexReaderConfig;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.topicmodel.AspectModel;
import dragon.ir.topicmodel.GibbsLDA;
import dragon.ir.topicmodel.SimpleMixtureModel;
import dragon.ir.topicmodel.TopicModel;
import dragon.matrix.vector.DoubleVector;

public class TopicModelConfig
extends ConfigUtil {
    public TopicModelConfig() {
    }

    public TopicModelConfig(ConfigureNode root2) {
        super(root2);
    }

    public TopicModelConfig(String configFile) {
        super(configFile);
    }

    public TopicModel getTopicModel(int modelID) {
        return this.getTopicModel(this.root, modelID);
    }

    public TopicModel getTopicModel(ConfigureNode node, int modelID) {
        return this.loadTopicModel(node, modelID);
    }

    private TopicModel loadTopicModel(ConfigureNode node, int modelID) {
        ConfigureNode modelNode = this.getConfigureNode(node, "topicmodel", modelID);
        if (modelNode == null) {
            return null;
        }
        String modelName = modelNode.getNodeName();
        return this.loadTopicModel(modelName, modelNode);
    }

    protected TopicModel loadTopicModel(String modelName, ConfigureNode modelNode) {
        if (modelName.equalsIgnoreCase("GibbsLDA")) {
            return this.loadGibbsLDA(modelNode);
        }
        if (modelName.equalsIgnoreCase("AspectModel")) {
            return this.loadAspectModel(modelNode);
        }
        if (modelName.equalsIgnoreCase("SimpleMixtureModel")) {
            return this.loadSimpleMixtureModel(modelNode);
        }
        return (TopicModel)this.loadResource(modelNode);
    }

    private TopicModel loadGibbsLDA(ConfigureNode node) {
        double alpha = node.getDouble("alpha");
        double beta = node.getDouble("beta");
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        GibbsLDA model = new GibbsLDA(indexReader, alpha, beta);
        model.setIterationNum(node.getInt("iterations", 100));
        model.setRandomSeed(node.getInt("randomseed", -1));
        return model;
    }

    private TopicModel loadAspectModel(ConfigureNode node) {
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        AspectModel model = new AspectModel(indexReader);
        model.setIterationNum(node.getInt("iterations", 100));
        model.setRandomSeed(node.getInt("randomseed", -1));
        return model;
    }

    private TopicModel loadSimpleMixtureModel(ConfigureNode node) {
        SimpleMixtureModel model;
        double bkgCoefficient = node.getDouble("bkgCoefficient");
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        int bkgIndexReaderID = node.getInt("bkgindexreader", indexReaderID);
        if (bkgIndexReaderID == indexReaderID) {
            model = new SimpleMixtureModel(indexReader, bkgCoefficient);
        } else {
            IndexReader bkgIndexReader = new IndexReaderConfig().getIndexReader(node, bkgIndexReaderID);
            DoubleVector bkgModel = this.getBackgroundModel(indexReader, bkgIndexReader);
            bkgIndexReader.close();
            model = new SimpleMixtureModel(indexReader, bkgModel, bkgCoefficient);
        }
        model.setIterationNum(node.getInt("iterations", 100));
        model.setRandomSeed(node.getInt("randomseed", -1));
        return model;
    }

    private DoubleVector getBackgroundModel(IndexReader indexReader, IndexReader bkgIndexReader) {
        DoubleVector bkgModel = new DoubleVector(indexReader.getCollection().getTermNum());
        boolean needSmooth = false;
        double sum2 = 0.0;
        int i = 0;
        while (i < bkgModel.size()) {
            int freq;
            IRTerm curTerm = bkgIndexReader.getIRTerm(indexReader.getTermKey(i));
            if (curTerm != null) {
                freq = curTerm.getFrequency();
                if (freq == 0) {
                    needSmooth = true;
                }
            } else {
                freq = 0;
                needSmooth = true;
            }
            sum2 += (double)freq;
            bkgModel.set(i, freq);
            ++i;
        }
        if (needSmooth) {
            i = 0;
            while (i < bkgModel.size()) {
                bkgModel.add(i, 1.0);
                ++i;
            }
            sum2 += (double)bkgModel.size();
        }
        bkgModel.multiply(1.0 / sum2);
        return bkgModel;
    }
}

