/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.TopicModelConfig;
import dragon.ir.topicmodel.ModelExcelWriter;
import dragon.ir.topicmodel.TopicModel;
import dragon.nlp.SimpleElementList;

public class TopicModelAppConfig {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please input two parameters: configuration xml file and indexing applicaiton id");
            return;
        }
        ConfigUtil util = new ConfigUtil();
        BasicConfigureNode root2 = new BasicConfigureNode(args[0]);
        ConfigureNode topicNode = util.getConfigureNode(root2, "topicmodelapp", Integer.parseInt(args[1]));
        if (topicNode == null) {
            return;
        }
        TopicModelAppConfig topicApp = new TopicModelAppConfig();
        topicApp.runTopicModel(topicNode);
    }

    public void runTopicModel(ConfigureNode node) {
        String termKeyFile;
        int topicNum = node.getInt("topicnum");
        int top = node.getInt("top", 20);
        int modelID = node.getInt("topicmodel");
        TopicModel topicModel = new TopicModelConfig().getTopicModel(node, modelID);
        String outputFile = node.getString("outputfile");
        if (!outputFile.endsWith(".xls")) {
            outputFile = outputFile + ".xls";
        }
        String[] termKeyList = (termKeyFile = node.getString("termkeyfile", null)) == null ? null : this.getTermKeyList(termKeyFile);
        if (!topicModel.estimateModel(topicNum)) {
            return;
        }
        ModelExcelWriter writer = new ModelExcelWriter();
        writer.write(topicModel, termKeyList, top, outputFile);
    }

    private String[] getTermKeyList(String termKeyFile) {
        SimpleElementList list2 = new SimpleElementList(termKeyFile, false);
        String[] termKeyList = new String[list2.size()];
        int i = 0;
        while (i < termKeyList.length) {
            termKeyList[i] = list2.search(i);
            ++i;
        }
        return termKeyList;
    }
}

