/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.nlp.tool.HeppleTagger;
import dragon.nlp.tool.MedPostTagger;
import dragon.nlp.tool.Tagger;

public class TaggerConfig
extends ConfigUtil {
    public TaggerConfig() {
    }

    public TaggerConfig(ConfigureNode root2) {
        super(root2);
    }

    public TaggerConfig(String configFile) {
        super(configFile);
    }

    public Tagger getTagger(int taggerID) {
        return this.getTagger(this.root, taggerID);
    }

    public Tagger getTagger(ConfigureNode node, int taggerID) {
        return this.loadTagger(node, taggerID);
    }

    private Tagger loadTagger(ConfigureNode node, int taggerID) {
        ConfigureNode taggerNode = this.getConfigureNode(node, "tagger", taggerID);
        if (taggerNode == null) {
            return null;
        }
        String taggerName = taggerNode.getNodeName();
        return this.loadTagger(taggerName, taggerNode);
    }

    protected Tagger loadTagger(String taggerName, ConfigureNode taggerNode) {
        String dataDir = taggerNode.getString("directory", null);
        if (taggerName.equalsIgnoreCase("MedPostTagger")) {
            if (dataDir == null) {
                return new MedPostTagger();
            }
            return new MedPostTagger(dataDir);
        }
        if (taggerName.equalsIgnoreCase("HeppleTagger")) {
            if (dataDir == null) {
                return new HeppleTagger();
            }
            return new HeppleTagger(dataDir);
        }
        return (Tagger)this.loadResource(taggerNode);
    }
}

