/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.IndexerConfig;
import dragon.config.KnowledgeBaseConfig;
import dragon.ir.index.sentence.OnlineSentenceIndexer;
import dragon.ir.kngbase.KnowledgeBase;
import dragon.ir.summarize.GenericMultiDocSummarizer;
import dragon.ir.summarize.LexRankSummarizer;
import dragon.ir.summarize.SemanticRankSummarizer;

public class SummarizerConfig
extends ConfigUtil {
    public SummarizerConfig() {
    }

    public SummarizerConfig(ConfigureNode root2) {
        super(root2);
    }

    public SummarizerConfig(String configFile) {
        super(configFile);
    }

    public GenericMultiDocSummarizer getGenericMultiDocSummarizer(int summarizerID) {
        return this.getGenericMultiDocSummarizer(this.root, summarizerID);
    }

    public GenericMultiDocSummarizer getGenericMultiDocSummarizer(ConfigureNode node, int summarizerID) {
        return this.loadGenericMultiDocSummarizer(node, summarizerID);
    }

    private GenericMultiDocSummarizer loadGenericMultiDocSummarizer(ConfigureNode node, int summarizerID) {
        ConfigureNode summarizerNode = this.getConfigureNode(node, "genericmultidocsummarizer", summarizerID);
        if (summarizerNode == null) {
            return null;
        }
        String summarizerName = summarizerNode.getNodeName();
        return this.loadGenericMultiDocSummarizer(summarizerName, summarizerNode);
    }

    protected GenericMultiDocSummarizer loadGenericMultiDocSummarizer(String summarizerName, ConfigureNode summarizerNode) {
        if (summarizerName.equalsIgnoreCase("LexRankSummarizer")) {
            return this.loadLexRankSummarizer(summarizerNode);
        }
        if (summarizerName.equalsIgnoreCase("SemanticRankSummarizer")) {
            return this.loadSemanticRankSummarizer(summarizerNode);
        }
        return (GenericMultiDocSummarizer)this.loadResource(summarizerNode);
    }

    private GenericMultiDocSummarizer loadLexRankSummarizer(ConfigureNode node) {
        boolean tfidf = node.getBoolean("tfidf", true);
        boolean continuous = node.getBoolean("continuousscore", true);
        double similarityThreshold = node.getDouble("similaritythreshold");
        int indexerID = node.getInt("onlinesentenceindexer");
        OnlineSentenceIndexer indexer = (OnlineSentenceIndexer)new IndexerConfig().getIndexer(node, indexerID);
        LexRankSummarizer summarizer = new LexRankSummarizer(indexer, tfidf);
        summarizer.setContinuousScoreOpiton(continuous);
        summarizer.setSimilarityThreshold(similarityThreshold);
        return summarizer;
    }

    private GenericMultiDocSummarizer loadSemanticRankSummarizer(ConfigureNode node) {
        SemanticRankSummarizer summarizer;
        double transCoefficient = node.getDouble("transcoefficient", 0.3);
        double bkgCoefficient = node.getDouble("bkgcoefficient", 0.5);
        int indexerID = node.getInt("tokenindexer");
        OnlineSentenceIndexer tokenIndexer = (OnlineSentenceIndexer)new IndexerConfig().getIndexer(node, indexerID);
        int kngID = node.getInt("knowledgebase");
        KnowledgeBase kngBase = new KnowledgeBaseConfig().getKnowledgeBase(node, kngID);
        indexerID = node.getInt("phraseindexer");
        if (indexerID > 0) {
            OnlineSentenceIndexer phraseIndexer = (OnlineSentenceIndexer)new IndexerConfig().getIndexer(node, indexerID);
            summarizer = new SemanticRankSummarizer(tokenIndexer, phraseIndexer, kngBase);
        } else {
            summarizer = new SemanticRankSummarizer(tokenIndexer, kngBase);
        }
        summarizer.setBackgroundCoefficient(bkgCoefficient);
        summarizer.setTranslationCoefficient(transCoefficient);
        summarizer.setMaxKLDivDistance(node.getDouble("maxkldivdistance", 10.0));
        return summarizer;
    }
}

