/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.SummarizerConfig;
import dragon.ir.summarize.GenericMultiDocSummarizer;
import dragon.ir.summarize.ROUGE;
import dragon.matrix.vector.DoubleVector;
import dragon.onlinedb.ArticleParser;
import dragon.onlinedb.SimpleCollectionReader;
import dragon.util.FileUtil;
import dragon.util.FormatUtil;
import dragon.util.WildCardFilter;
import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class SummarizationEvaAppConfig {
    PrintWriter out;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please input two parameters: configuration xml file and retrieval evaluation id");
            return;
        }
        ConfigUtil util = new ConfigUtil();
        BasicConfigureNode root2 = new BasicConfigureNode(args[0]);
        ConfigureNode sumAppNode = util.getConfigureNode(root2, "summarizationevaapp", Integer.parseInt(args[1]));
        if (sumAppNode == null) {
            return;
        }
        SummarizationEvaAppConfig sumApp = new SummarizationEvaAppConfig();
        sumApp.evaluate(sumAppNode);
    }

    public void evaluate(ConfigureNode node) {
        int summarizerID = node.getInt("summarizer");
        GenericMultiDocSummarizer summarizer = new SummarizerConfig().getGenericMultiDocSummarizer(node, summarizerID);
        ArticleParser parser = this.getArticleParser(node.getString("articleparser"));
        String testDataFolder = node.getString("testdatafolder");
        String modelSummaryFolder = node.getString("modelsummaryfolder");
        String outputFolder = node.getString("outputfolder");
        int maxLength = node.getInt("maxlength");
        this.evaluate(summarizer, parser, testDataFolder, modelSummaryFolder, outputFolder, maxLength);
    }

    public void evaluate(GenericMultiDocSummarizer summarizer, ArticleParser parser, String testDataFolder, String modelSummaryFolder, String outputFolder, int maxLength) {
        ROUGE rouge = new ROUGE();
        rouge.setStopwordOption(false);
        rouge.setLemmatiserOption(false);
        rouge.setCaseOption(false);
        DecimalFormat df = FormatUtil.getNumericFormat(1, 4);
        DoubleVector result2 = new DoubleVector(6);
        result2.assign(0.0);
        String[] clusterNames = new File(testDataFolder).list();
        new File(outputFolder).mkdirs();
        this.out = FileUtil.getPrintWriter(outputFolder + "/eva.txt");
        this.printHeader();
        int i = 0;
        while (i < clusterNames.length) {
            SimpleCollectionReader reader = new SimpleCollectionReader(testDataFolder + "/" + clusterNames[i], parser);
            String[] refSummaries = this.getModelSummaries(modelSummaryFolder, clusterNames[i]);
            String summary = summarizer.summarize(reader, maxLength);
            reader.close();
            FileUtil.saveTextFile(outputFolder + "/" + clusterNames[i] + "_sum.txt", summary);
            result2.add(this.evaluate(rouge, clusterNames[i], summary, refSummaries));
            ++i;
        }
        result2.multiply(1.0 / (double)clusterNames.length);
        this.write("Average\t" + df.format(result2.get(0)) + "\t" + df.format(result2.get(1)) + "\t" + df.format(result2.get(2)) + "\t" + df.format(result2.get(3)) + "\t" + df.format(result2.get(4)) + "\t" + df.format(result2.get(5)));
        this.out.close();
    }

    private void printHeader() {
        this.write("Run\tR-1.Min\tR-1.Max\tR-1.Avg\tR-2.Min\tR-2.Max\tR-2.Avg");
    }

    private DoubleVector evaluate(ROUGE rouge, String clusterName, String autoSummary, String[] refSummaries) {
        DecimalFormat df = FormatUtil.getNumericFormat(1, 4);
        DoubleVector result2 = new DoubleVector(6);
        rouge.useRougeN(1);
        rouge.evaluate(autoSummary, refSummaries);
        rouge.setMultipleReferenceMode(2);
        result2.set(0, rouge.getRecall());
        rouge.setMultipleReferenceMode(1);
        result2.set(1, rouge.getRecall());
        rouge.setMultipleReferenceMode(3);
        result2.set(2, rouge.getRecall());
        rouge.useRougeN(2);
        rouge.evaluate(autoSummary, refSummaries);
        rouge.setMultipleReferenceMode(2);
        result2.set(3, rouge.getRecall());
        rouge.setMultipleReferenceMode(1);
        result2.set(4, rouge.getRecall());
        rouge.setMultipleReferenceMode(3);
        result2.set(5, rouge.getRecall());
        this.write(clusterName + "\t" + df.format(result2.get(0)) + "\t" + df.format(result2.get(1)) + "\t" + df.format(result2.get(2)) + "\t" + df.format(result2.get(3)) + "\t" + df.format(result2.get(4)) + "\t" + df.format(result2.get(5)));
        return result2;
    }

    private String[] getModelSummaries(String modelFolder, String clusterName) {
        File modelDir = new File(modelFolder);
        File[] arrSum = modelDir.listFiles(new WildCardFilter(clusterName + "*"));
        if (arrSum == null || arrSum.length == 0) {
            clusterName = clusterName.substring(0, clusterName.length() - 1);
            arrSum = modelDir.listFiles(new WildCardFilter(clusterName + "*"));
        }
        ArrayList<String> list2 = new ArrayList<String>(arrSum.length);
        String[] summaries = new String[arrSum.length];
        int i = 0;
        while (i < arrSum.length) {
            if (arrSum[i].isFile()) {
                list2.add(FileUtil.readTextFile(arrSum[i]));
            }
            ++i;
        }
        summaries = new String[list2.size()];
        i = 0;
        while (i < summaries.length) {
            summaries[i] = (String)list2.get(i);
            ++i;
        }
        return summaries;
    }

    private void write(String message) {
        System.out.println(message);
        if (this.out != null) {
            this.out.println(message);
            this.out.flush();
        }
    }

    private ArticleParser getArticleParser(String className) {
        try {
            Class<?> myClass = Class.forName(className);
            return (ArticleParser)myClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

