/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.FeedbackConfig;
import dragon.config.IndexReaderConfig;
import dragon.config.SmootherConfig;
import dragon.ir.index.IndexReader;
import dragon.ir.search.BoolRankSearcher;
import dragon.ir.search.FeedbackSearcher;
import dragon.ir.search.FullRankSearcher;
import dragon.ir.search.PartialRankSearcher;
import dragon.ir.search.Searcher;
import dragon.ir.search.feedback.Feedback;
import dragon.ir.search.smooth.Smoother;

public class SearcherConfig
extends ConfigUtil {
    public SearcherConfig() {
    }

    public SearcherConfig(ConfigureNode root2) {
        super(root2);
    }

    public SearcherConfig(String configFile) {
        super(configFile);
    }

    public Searcher getSearcher(int searcherID) {
        return this.getSearcher(this.root, searcherID);
    }

    public Searcher getSearcher(ConfigureNode node, int searcherID) {
        return this.loadSearcher(node, searcherID);
    }

    private Searcher loadSearcher(ConfigureNode node, int searcherID) {
        ConfigureNode searcherNode = this.getConfigureNode(node, "searcher", searcherID);
        if (searcherNode == null) {
            return null;
        }
        String searcherName = searcherNode.getNodeName();
        return this.loadSearcher(searcherName, searcherNode);
    }

    protected Searcher loadSearcher(String searcherName, ConfigureNode searcherNode) {
        if (searcherName.equalsIgnoreCase("FullRankSearcher")) {
            return this.loadFullRankSearcher(searcherNode);
        }
        if (searcherName.equalsIgnoreCase("PartialRankSearcher")) {
            return this.loadPartialRankSearcher(searcherNode);
        }
        if (searcherName.equalsIgnoreCase("BoolRankSearcher")) {
            return this.loadBoolRankSearcher(searcherNode);
        }
        if (searcherName.equalsIgnoreCase("FeedbackSearcher")) {
            return this.loadFeedbackSearcher(searcherNode);
        }
        return (Searcher)this.loadResource(searcherNode);
    }

    private Searcher loadFullRankSearcher(ConfigureNode node) {
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        return new FullRankSearcher(indexReader, this.getSmoother(node));
    }

    private Searcher loadPartialRankSearcher(ConfigureNode node) {
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        return new PartialRankSearcher(indexReader, this.getSmoother(node));
    }

    private Searcher loadBoolRankSearcher(ConfigureNode node) {
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        return new BoolRankSearcher(indexReader, this.getSmoother(node));
    }

    private Searcher loadFeedbackSearcher(ConfigureNode node) {
        FeedbackConfig config = new FeedbackConfig();
        int feedbackID = node.getInt("feedback");
        Feedback feedback = config.getFeedback(node, feedbackID);
        boolean sameSearcher = node.getBoolean("sameasinitsearcher", false);
        if (sameSearcher) {
            return new FeedbackSearcher(feedback.getSearcher(), feedback);
        }
        int searcherID = node.getInt("searcher");
        return new FeedbackSearcher(this.getSearcher(node, searcherID), feedback);
    }

    private Smoother getSmoother(ConfigureNode node) {
        int smootherID = node.getInt("smoother", 0);
        if (smootherID <= 0) {
            return null;
        }
        SmootherConfig config = new SmootherConfig();
        return config.getSmoother(node, smootherID);
    }
}

