/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.CollectionReaderConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.QueryGeneratorConfig;
import dragon.ir.query.QueryGenerator;
import dragon.onlinedb.Article;
import dragon.onlinedb.CollectionReader;
import dragon.util.FileUtil;
import java.io.PrintWriter;
import java.util.ArrayList;

public class QueryAppConfig {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please input two parameters: configuration xml file and indexing applicaiton id");
            return;
        }
        ConfigUtil util = new ConfigUtil();
        BasicConfigureNode root2 = new BasicConfigureNode(args[0]);
        ConfigureNode indexAppNode = util.getConfigureNode(root2, "queryapp", Integer.parseInt(args[1]));
        if (indexAppNode == null) {
            return;
        }
        QueryAppConfig queryApp = new QueryAppConfig();
        queryApp.generateQuery(indexAppNode);
    }

    public void generateQuery(ConfigureNode indexAppNode) {
        int collectionID = indexAppNode.getInt("topicreader");
        int queryGeneratorID = indexAppNode.getInt("querygenerator");
        CollectionReader topicReader = new CollectionReaderConfig().getCollectionReader(indexAppNode, collectionID);
        QueryGenerator queryGenerator = new QueryGeneratorConfig().getQueryGenerator(indexAppNode, queryGeneratorID);
        String queryFile = indexAppNode.getString("queryfile");
        this.generateQuery(queryGenerator, topicReader, queryFile);
    }

    /*
     * WARNING - void declaration
     */
    public void generateQuery(QueryGenerator queryGenerator, CollectionReader topicReader, String queryFile) {
        try {
            Article article;
            ArrayList<void> topics = new ArrayList<void>();
            while ((article = topicReader.getNextArticle()) != null) {
                void var6_5;
                topics.add(var6_5);
            }
            PrintWriter out = FileUtil.getPrintWriter(queryFile);
            out.write(topics.size() + "\n");
            int i = 0;
            while (i < topics.size()) {
                article = (Article)topics.get(i);
                String curQuery = queryGenerator.generate(article).toString();
                out.write(article.getCategory() + "\t" + curQuery + "\n");
                out.flush();
                ++i;
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

