/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.CollectionReaderConfig;
import dragon.config.ConceptExtractorConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.SparseMatrixConfig;
import dragon.ir.kngbase.BasicKnowledgeBase;
import dragon.ir.kngbase.HALSpace;
import dragon.ir.kngbase.KnowledgeBase;
import dragon.matrix.DoubleSparseMatrix;
import dragon.nlp.SimpleElementList;
import dragon.nlp.extract.TokenExtractor;
import dragon.onlinedb.CollectionReader;

public class KnowledgeBaseConfig
extends ConfigUtil {
    public KnowledgeBaseConfig() {
    }

    public KnowledgeBaseConfig(ConfigureNode root2) {
        super(root2);
    }

    public KnowledgeBaseConfig(String configFile) {
        super(configFile);
    }

    public KnowledgeBase getKnowledgeBase(int kngBaseID) {
        return this.getKnowledgeBase(this.root, kngBaseID);
    }

    public KnowledgeBase getKnowledgeBase(ConfigureNode node, int kngBaseID) {
        return this.loadKnowledgeBase(node, kngBaseID);
    }

    private KnowledgeBase loadKnowledgeBase(ConfigureNode node, int kngBaseID) {
        ConfigureNode kngBaseNode = this.getConfigureNode(node, "knowledgebase", kngBaseID);
        if (kngBaseNode == null) {
            return null;
        }
        String kngBaseName = kngBaseNode.getNodeName();
        return this.loadKnowledgeBase(kngBaseName, kngBaseNode);
    }

    protected KnowledgeBase loadKnowledgeBase(String kngBaseName, ConfigureNode kngBaseNode) {
        if (kngBaseName.equalsIgnoreCase("BasicKnowledgeBase")) {
            return this.loadBasicKnowledgeBase(kngBaseNode);
        }
        if (kngBaseName.equalsIgnoreCase("HALSpace")) {
            return this.loadHALSpace(kngBaseNode);
        }
        return (KnowledgeBase)this.loadResource(kngBaseNode);
    }

    private KnowledgeBase loadBasicKnowledgeBase(ConfigureNode node) {
        String rowKeyListFile = node.getString("rowkeyfile");
        String columnKeyListFile = node.getString("columnkeyfile");
        int kngMatrixID = node.getInt("knowledgematrix");
        DoubleSparseMatrix kngMatrix = new SparseMatrixConfig().getDoubleSparseMatrix(node, kngMatrixID);
        return new BasicKnowledgeBase(kngMatrix, new SimpleElementList(rowKeyListFile, false), new SimpleElementList(columnKeyListFile, false));
    }

    private KnowledgeBase loadHALSpace(ConfigureNode node) {
        String matrixFile = node.getString("matrixfile");
        String indexFile = node.getString("indexfile");
        String termListFile = node.getString("termkeyfile");
        int windowSize = node.getInt("windowsize");
        int collectionID = node.getInt("collectionreader");
        CollectionReader reader = new CollectionReaderConfig().getCollectionReader(node, collectionID);
        int tokenExtractorID = node.getInt("tokenextractor");
        TokenExtractor extractor = (TokenExtractor)new ConceptExtractorConfig().getConceptExtractor(node, tokenExtractorID);
        HALSpace hal = matrixFile != null && indexFile != null ? new HALSpace(new SimpleElementList(termListFile, false), extractor, windowSize, indexFile, matrixFile) : (termListFile != null ? new HALSpace(new SimpleElementList(termListFile, false), extractor, windowSize) : new HALSpace(extractor, windowSize));
        if (reader != null) {
            hal.add(reader);
            hal.finalizeData();
        }
        return hal;
    }
}

