/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.nlp.DocumentParser;
import dragon.nlp.extract.EngDocumentParser;

public class DocumentParserConfig
extends ConfigUtil {
    public DocumentParserConfig() {
    }

    public DocumentParserConfig(ConfigureNode root2) {
        super(root2);
    }

    public DocumentParserConfig(String configFile) {
        super(configFile);
    }

    public DocumentParser getDocumentParser(int parserID) {
        return this.getDocumentParser(this.root, parserID);
    }

    public DocumentParser getDocumentParser(ConfigureNode node, int parserID) {
        return this.loadDocumentParser(node, parserID);
    }

    private DocumentParser loadDocumentParser(ConfigureNode node, int parserID) {
        ConfigureNode parserNode = this.getConfigureNode(node, "documentparser", parserID);
        if (parserNode == null) {
            return null;
        }
        String parserName = parserNode.getNodeName();
        return this.loadDocumentParser(parserName, parserNode);
    }

    protected DocumentParser loadDocumentParser(String parserName, ConfigureNode parserNode) {
        if (parserName.equalsIgnoreCase("EngDocumentParser")) {
            return this.loadEngDocumentParser(parserNode);
        }
        return (DocumentParser)this.loadResource(parserNode);
    }

    private DocumentParser loadEngDocumentParser(ConfigureNode node) {
        return new EngDocumentParser(this.getWordDelimitor(node.getString("notworddelimitor", "")));
    }

    private String getWordDelimitor(String notWordDelimitor) {
        StringBuffer sb = new StringBuffer();
        String delimitors = " \r\n\t_-.;,?/\"'`:(){}!+[]><=%$#*@&^~|\\";
        if (notWordDelimitor == null && notWordDelimitor.length() == 0) {
            return delimitors;
        }
        int i = 0;
        while (i < delimitors.length()) {
            if (notWordDelimitor.indexOf(delimitors.charAt(i)) < 0) {
                sb.append(delimitors.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

