/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ClusterModelConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.DocDistanceConfig;
import dragon.config.FeatureFilterConfig;
import dragon.config.IndexReaderConfig;
import dragon.config.SparseMatrixConfig;
import dragon.ir.clustering.BasicKMean;
import dragon.ir.clustering.BisectKMean;
import dragon.ir.clustering.Clustering;
import dragon.ir.clustering.HierClustering;
import dragon.ir.clustering.LinkKMean;
import dragon.ir.clustering.clustermodel.ClusterModel;
import dragon.ir.clustering.docdistance.DocDistance;
import dragon.ir.index.IndexReader;
import dragon.matrix.SparseMatrix;

public class ClusteringConfig
extends ConfigUtil {
    public ClusteringConfig() {
    }

    public ClusteringConfig(ConfigureNode root2) {
        super(root2);
    }

    public ClusteringConfig(String configFile) {
        super(configFile);
    }

    public Clustering getClustering(int clusteringID) {
        return this.getClustering(this.root, clusteringID);
    }

    public Clustering getClustering(ConfigureNode node, int clusteringID) {
        return this.loadClustering(node, clusteringID);
    }

    private Clustering loadClustering(ConfigureNode node, int clusteringID) {
        ConfigureNode clusteringNode = this.getConfigureNode(node, "clustering", clusteringID);
        if (clusteringNode == null) {
            return null;
        }
        String clusteringName = clusteringNode.getNodeName();
        return this.loadClustering(clusteringName, clusteringNode);
    }

    protected Clustering loadClustering(String clusteringName, ConfigureNode clusteringNode) {
        if (clusteringName.equalsIgnoreCase("HierClustering")) {
            return this.loadHierClustering(clusteringNode);
        }
        if (clusteringName.equalsIgnoreCase("BasicKMean")) {
            return this.loadBasicKMean(clusteringNode);
        }
        if (clusteringName.equalsIgnoreCase("BisectKMean")) {
            return this.loadBisectKMean(clusteringNode);
        }
        if (clusteringName.equalsIgnoreCase("LinkKMean")) {
            return this.loadLinkKMean(clusteringNode);
        }
        return (Clustering)this.loadResource(clusteringNode);
    }

    private Clustering loadHierClustering(ConfigureNode node) {
        int linkage;
        int clusterNum = node.getInt("clusternum");
        int filterID = node.getInt("featurefilter", -1);
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        int docDistanceID = node.getInt("docdistance");
        DocDistance docDistance = new DocDistanceConfig().getDocDistance(node, docDistanceID);
        String linkageMode = node.getString("linkage", "complete");
        if (linkageMode.equalsIgnoreCase("complete")) {
            linkage = 1;
        } else if (linkageMode.equalsIgnoreCase("average")) {
            linkage = 0;
        } else if (linkageMode.equalsIgnoreCase("single")) {
            linkage = -1;
        } else {
            return null;
        }
        HierClustering clustering = new HierClustering(indexReader, docDistance, clusterNum, linkage);
        if (filterID > 0) {
            clustering.setFeatureFilter(new FeatureFilterConfig().getFeatureFilter(node, filterID));
        }
        return clustering;
    }

    private Clustering loadBasicKMean(ConfigureNode node) {
        int clusterNum = node.getInt("clusternum");
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        int clusterModelID = node.getInt("clustermodel");
        ClusterModel clusterModel = new ClusterModelConfig().getClusterModel(node, clusterModelID);
        int maxIteration = node.getInt("maxiteration", 50);
        long randomSeed = node.getInt("randomseed", -1);
        int filterID = node.getInt("featurefilter", -1);
        boolean initAllObjects = node.getBoolean("initallobjects", false);
        BasicKMean kmean = new BasicKMean(indexReader, clusterModel, clusterNum, initAllObjects);
        kmean.setMaxIteration(maxIteration);
        kmean.setRandomSeed(randomSeed);
        if (filterID > 0) {
            kmean.setFeatureFilter(new FeatureFilterConfig().getFeatureFilter(node, filterID));
        }
        return kmean;
    }

    private Clustering loadBisectKMean(ConfigureNode node) {
        int clusterNum = node.getInt("clusternum");
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        int clusterModelID = node.getInt("clustermodel");
        ClusterModel clusterModel = new ClusterModelConfig().getClusterModel(node, clusterModelID);
        boolean refine = node.getBoolean("refine", true);
        int maxIteration = node.getInt("maxiteration", 50);
        long randomSeed = node.getInt("randomseed", -1);
        int filterID = node.getInt("featurefilter", -1);
        boolean initAllObjects = node.getBoolean("initallobjects", false);
        BisectKMean kmean = new BisectKMean(indexReader, clusterModel, clusterNum, initAllObjects);
        kmean.setMaxIteration(maxIteration);
        kmean.setRandomSeed(randomSeed);
        kmean.setRefine(refine);
        if (filterID > 0) {
            kmean.setFeatureFilter(new FeatureFilterConfig().getFeatureFilter(node, filterID));
        }
        return kmean;
    }

    private Clustering loadLinkKMean(ConfigureNode node) {
        int clusteringID = node.getInt("initclustering");
        Clustering initClustering = new ClusteringConfig().getClustering(node, clusteringID);
        int outLinkID = node.getInt("outlinkmatrix");
        String paraType = node.getParameterType("outlinkmatrix");
        SparseMatrix outLinks = paraType == null || paraType.equalsIgnoreCase("intsparematrix") ? new SparseMatrixConfig().getIntSparseMatrix(node, outLinkID) : new SparseMatrixConfig().getDoubleSparseMatrix(node, outLinkID);
        int inLinkID = node.getInt("inlinkmatrix");
        SparseMatrix inLinks = inLinkID <= 0 || inLinkID == outLinkID ? null : ((paraType = node.getParameterType("inlinkmatrix")) == null || paraType.equalsIgnoreCase("intsparematrix") ? new SparseMatrixConfig().getIntSparseMatrix(node, inLinkID) : new SparseMatrixConfig().getDoubleSparseMatrix(node, inLinkID));
        LinkKMean kmean = new LinkKMean(initClustering, outLinks, inLinks);
        kmean.setMaxIteration(node.getInt("maxiteration", 10));
        kmean.setRandomSeed(node.getInt("randomseed", -1));
        kmean.setUseWeight(node.getBoolean("useweight", false));
        return kmean;
    }
}

