/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.IndexReaderConfig;
import dragon.config.KnowledgeBaseConfig;
import dragon.config.SparseMatrixConfig;
import dragon.ir.clustering.clustermodel.ClusterModel;
import dragon.ir.clustering.clustermodel.CosineClusterModel;
import dragon.ir.clustering.clustermodel.EuclideanClusterModel;
import dragon.ir.clustering.clustermodel.MultinomialClusterModel;
import dragon.ir.index.IndexReader;
import dragon.ir.kngbase.KnowledgeBase;
import dragon.matrix.DoubleSparseMatrix;

public class ClusterModelConfig
extends ConfigUtil {
    public ClusterModelConfig() {
    }

    public ClusterModelConfig(ConfigureNode root2) {
        super(root2);
    }

    public ClusterModelConfig(String configFile) {
        super(configFile);
    }

    public ClusterModel getClusterModel(int clusterModelID) {
        return this.getClusterModel(this.root, clusterModelID);
    }

    public ClusterModel getClusterModel(ConfigureNode node, int clusterModelID) {
        return this.loadClusterModel(node, clusterModelID);
    }

    private ClusterModel loadClusterModel(ConfigureNode node, int clusterModelID) {
        ConfigureNode clusterModelNode = this.getConfigureNode(node, "clustermodel", clusterModelID);
        if (clusterModelNode == null) {
            return null;
        }
        String clusterModelName = clusterModelNode.getNodeName();
        return this.loadClusterModel(clusterModelName, clusterModelNode);
    }

    protected ClusterModel loadClusterModel(String clusterModelName, ConfigureNode clusterModelNode) {
        if (clusterModelName.equalsIgnoreCase("CosineClusterModel")) {
            return this.loadCosineClusterModel(clusterModelNode);
        }
        if (clusterModelName.equalsIgnoreCase("EuclideanClusterModel")) {
            return this.loadEuclideanClusterModel(clusterModelNode);
        }
        if (clusterModelName.equalsIgnoreCase("MultinomialClusterModel")) {
            return this.loadMultinomialClusterModel(clusterModelNode);
        }
        return (ClusterModel)this.loadResource(clusterModelNode);
    }

    private ClusterModel loadCosineClusterModel(ConfigureNode node) {
        int clusterNum = node.getInt("clusternum");
        int matrixID = node.getInt("doublematrix", -1);
        if (matrixID > 0) {
            return new CosineClusterModel(clusterNum, new SparseMatrixConfig().getDoubleSparseMatrix(node, matrixID));
        }
        matrixID = node.getInt("intmatrix", -1);
        return new CosineClusterModel(clusterNum, new SparseMatrixConfig().getIntSparseMatrix(node, matrixID));
    }

    private ClusterModel loadEuclideanClusterModel(ConfigureNode node) {
        int clusterNum = node.getInt("clusternum");
        int matrixID = node.getInt("doublematrix", -1);
        if (matrixID > 0) {
            return new EuclideanClusterModel(clusterNum, new SparseMatrixConfig().getDoubleSparseMatrix(node, matrixID));
        }
        matrixID = node.getInt("intmatrix", -1);
        return new EuclideanClusterModel(clusterNum, new SparseMatrixConfig().getIntSparseMatrix(node, matrixID));
    }

    private ClusterModel loadMultinomialClusterModel(ConfigureNode node) {
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        int clusterNum = node.getInt("clusternum");
        double bkgCoefficient = node.getDouble("bkgcoefficient", -1.0);
        if (bkgCoefficient <= 0.0) {
            return new MultinomialClusterModel(clusterNum, indexReader);
        }
        int matrixID = node.getInt("transmatrix");
        int kngID = node.getInt("knowledgebase");
        int topicIndexReaderID = node.getInt("topicindexreader", indexReaderID);
        if (matrixID <= 0 && kngID <= 0) {
            return new MultinomialClusterModel(clusterNum, indexReader, bkgCoefficient);
        }
        IndexReader topicIndexReader = topicIndexReaderID == indexReaderID ? indexReader : new IndexReaderConfig().getIndexReader(node, topicIndexReaderID);
        double transCoefficient = node.getDouble("transcoefficient");
        if (matrixID > 0) {
            DoubleSparseMatrix topicTransMatrix = new SparseMatrixConfig().getDoubleSparseMatrix(node, matrixID);
            return new MultinomialClusterModel(clusterNum, indexReader, topicIndexReader, topicTransMatrix, transCoefficient, bkgCoefficient);
        }
        KnowledgeBase kngBase = new KnowledgeBaseConfig().getKnowledgeBase(node, kngID);
        return new MultinomialClusterModel(clusterNum, indexReader, topicIndexReader, kngBase, transCoefficient, bkgCoefficient);
    }
}

