/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.CodeMatrixConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.FeatureSelectorConfig;
import dragon.config.IndexReaderConfig;
import dragon.config.KnowledgeBaseConfig;
import dragon.config.MultiClassDecoderConfig;
import dragon.config.SparseMatrixConfig;
import dragon.ir.classification.Classifier;
import dragon.ir.classification.DocClass;
import dragon.ir.classification.LibSVMClassifier;
import dragon.ir.classification.NBClassifier;
import dragon.ir.classification.NigamActiveLearning;
import dragon.ir.classification.SVMLightClassifier;
import dragon.ir.classification.SemanticNBClassifier;
import dragon.ir.classification.featureselection.FeatureSelector;
import dragon.ir.index.IndexReader;
import dragon.ir.kngbase.KnowledgeBase;
import dragon.matrix.DoubleSparseMatrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class ClassifierConfig
extends ConfigUtil {
    public ClassifierConfig() {
    }

    public ClassifierConfig(ConfigureNode root2) {
        super(root2);
    }

    public ClassifierConfig(String configFile) {
        super(configFile);
    }

    public Classifier getClassifier(int classifierID) {
        return this.getClassifier(this.root, classifierID);
    }

    public Classifier getClassifier(ConfigureNode node, int classifierID) {
        return this.loadClassifier(node, classifierID);
    }

    private Classifier loadClassifier(ConfigureNode node, int classifierID) {
        ConfigureNode classifierNode = this.getConfigureNode(node, "classifier", classifierID);
        if (classifierNode == null) {
            return null;
        }
        String classifierName = classifierNode.getNodeName();
        return this.loadClassifier(classifierName, classifierNode);
    }

    protected Classifier loadClassifier(String classifierName, ConfigureNode classifierNode) {
        if (classifierName.equalsIgnoreCase("NBClassifier")) {
            return this.loadNBClassifier(classifierNode);
        }
        if (classifierName.equalsIgnoreCase("SVMLightClassifier")) {
            return this.loadSVMLightClassifier(classifierNode);
        }
        if (classifierName.equalsIgnoreCase("LibSVMClassifier")) {
            return this.loadLibSVMClassifier(classifierNode);
        }
        if (classifierName.equalsIgnoreCase("NigamActiveLearning")) {
            return this.loadNigamActiveLearning(classifierNode);
        }
        if (classifierName.equalsIgnoreCase("SemanticNBClassifier")) {
            return this.loadSemanticNBClassifier(classifierNode);
        }
        return (Classifier)this.loadResource(classifierNode);
    }

    private Classifier loadNBClassifier(ConfigureNode node) {
        NBClassifier classifier;
        int indexReaderID = node.getInt("indexreader");
        if (indexReaderID > 0) {
            classifier = new NBClassifier(new IndexReaderConfig().getIndexReader(node, indexReaderID));
        } else {
            int matrixID = node.getInt("doctermmatrix");
            classifier = new NBClassifier(new SparseMatrixConfig().getDoubleSparseMatrix(node, matrixID));
        }
        int selectorID = node.getInt("featureselector");
        FeatureSelector featureSelector = new FeatureSelectorConfig().getFeatureSelector(node, selectorID);
        if (featureSelector != null) {
            classifier.setFeatureSelector(featureSelector);
        }
        return classifier;
    }

    private Classifier loadSVMLightClassifier(ConfigureNode node) {
        int decoderID;
        int matrixID;
        SVMLightClassifier classifier;
        int indexReaderID = node.getInt("indexreader");
        if (indexReaderID > 0) {
            classifier = new SVMLightClassifier(new IndexReaderConfig().getIndexReader(node, indexReaderID));
        } else {
            matrixID = node.getInt("doctermmatrix");
            classifier = new SVMLightClassifier(new SparseMatrixConfig().getDoubleSparseMatrix(node, matrixID));
        }
        int selectorID = node.getInt("featureselector");
        FeatureSelector featureSelector = new FeatureSelectorConfig().getFeatureSelector(node, selectorID);
        if (featureSelector != null) {
            classifier.setFeatureSelector(featureSelector);
        }
        if ((matrixID = node.getInt("codematrix")) > 0) {
            classifier.setCodeMatrix(new CodeMatrixConfig().getCodeMatrix(node, matrixID));
        }
        if ((decoderID = node.getInt("multiclassdecoder")) > 0) {
            classifier.setMultiClassDecoder(new MultiClassDecoderConfig().getMultiClassDecoder(node, decoderID));
        }
        classifier.setScalingOption(node.getBoolean("scaling", false));
        return classifier;
    }

    private Classifier loadLibSVMClassifier(ConfigureNode node) {
        int decoderID;
        LibSVMClassifier classifier;
        int indexReaderID = node.getInt("indexreader");
        if (indexReaderID > 0) {
            classifier = new LibSVMClassifier(new IndexReaderConfig().getIndexReader(node, indexReaderID));
        } else {
            int matrixID = node.getInt("doctermmatrix");
            classifier = new LibSVMClassifier(new SparseMatrixConfig().getDoubleSparseMatrix(node, matrixID));
        }
        int selectorID = node.getInt("featureselector");
        FeatureSelector featureSelector = new FeatureSelectorConfig().getFeatureSelector(node, selectorID);
        if (featureSelector != null) {
            classifier.setFeatureSelector(featureSelector);
        }
        if ((decoderID = node.getInt("multiclassdecoder")) > 0) {
            classifier.setMultiClassDecoder(new MultiClassDecoderConfig().getMultiClassDecoder(node, decoderID));
        }
        classifier.setScalingOption(node.getBoolean("scaling", false));
        classifier.setScalingOption(node.getBoolean("propestimate", true));
        return classifier;
    }

    private Classifier loadNigamActiveLearning(ConfigureNode node) {
        int selectorID = node.getInt("featureselector");
        FeatureSelector featureSelector = new FeatureSelectorConfig().getFeatureSelector(node, selectorID);
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        double unlabeledRate = node.getDouble("unlabeledrate", 0.0);
        NigamActiveLearning classifier = new NigamActiveLearning(indexReader, unlabeledRate);
        if (featureSelector != null) {
            classifier.setFeatureSelector(featureSelector);
        }
        indexReaderID = node.getInt("unlabeledindexreader");
        int unlabeledDocNum = node.getInt("unlabeleddocnum");
        if (indexReaderID > 0 && unlabeledDocNum > 0) {
            indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
            classifier.setUnlabeledData(indexReader, this.prepareUnlabeledDocSet(indexReader, 10, unlabeledDocNum));
        }
        return classifier;
    }

    private DocClass prepareUnlabeledDocSet(IndexReader reader, int randomSeed, int num2) {
        if (reader == null) {
            return null;
        }
        int docNum = reader.getCollection().getDocNum();
        ArrayList<Integer> list2 = new ArrayList<Integer>(docNum);
        int i = 0;
        while (i < docNum) {
            list2.add(new Integer(i));
            ++i;
        }
        Collections.shuffle(list2, new Random(randomSeed));
        DocClass docSet = new DocClass(0);
        i = 0;
        while (i < num2) {
            docSet.addDoc(reader.getDoc((Integer)list2.get(i)));
            ++i;
        }
        return docSet;
    }

    private Classifier loadSemanticNBClassifier(ConfigureNode node) {
        SemanticNBClassifier classifier;
        double bkgCoefficient = node.getDouble("bkgcoefficient");
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        int matrixID = node.getInt("transmatrix");
        int kngID = node.getInt("knowledgebase");
        if (matrixID > 0) {
            double transCoefficient = node.getDouble("transcoefficient");
            DoubleSparseMatrix transMatrix = new SparseMatrixConfig().getDoubleSparseMatrix(node, matrixID);
            int topicIndexReaderID = node.getInt("topicindexreader", indexReaderID);
            IndexReader topicIndexReader = topicIndexReaderID == indexReaderID ? indexReader : new IndexReaderConfig().getIndexReader(node, topicIndexReaderID);
            classifier = new SemanticNBClassifier(indexReader, topicIndexReader, transMatrix, transCoefficient, bkgCoefficient);
        } else if (kngID > 0) {
            double transCoefficient = node.getDouble("transcoefficient");
            KnowledgeBase kngBase = new KnowledgeBaseConfig().getKnowledgeBase(node, kngID);
            int topicIndexReaderID = node.getInt("topicindexreader", indexReaderID);
            IndexReader topicIndexReader = topicIndexReaderID == indexReaderID ? indexReader : new IndexReaderConfig().getIndexReader(node, topicIndexReaderID);
            classifier = new SemanticNBClassifier(indexReader, topicIndexReader, kngBase, transCoefficient, bkgCoefficient);
        } else {
            classifier = new SemanticNBClassifier(indexReader, bkgCoefficient);
        }
        int selectorID = node.getInt("featureselector");
        if (selectorID > 0) {
            classifier.setFeatureSelector(new FeatureSelectorConfig().getFeatureSelector(node, selectorID));
        }
        return classifier;
    }
}

