/*
 * Decompiled with CFR 0.152.
 */
package dl.tmp;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

public class GrammarToBackusNaur {
    public static void main(String[] args) throws ValidityException, ParsingException, IOException {
        XMLReader xmlReader;
        InputStream is = GrammarToBackusNaur.class.getClassLoader().getResourceAsStream("uk/ac/cam/ch/wwmm/opsin/resources/regexes.xml");
        try {
            xmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new RuntimeException("No XML Reader could be initialised!", e);
        }
        try {
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException("Your system's default XML Reader does not support disabling DTD loading! Maybe try updating your version of java?", e);
        }
        catch (SAXNotRecognizedException e) {
            throw new RuntimeException("Your system's default XML Reader has not recognised the DTD loading feature! Maybe try updating your version of java?", e);
        }
        Document doc = new Builder(xmlReader).build(is);
        List<Element> regexes = XOMTools.getChildElementsWithTagName(doc.getRootElement(), "regex");
        for (Element regex : regexes) {
            String name = regex.getAttributeValue("name");
            if (!name.startsWith("%") || !name.endsWith("%")) {
                throw new RuntimeException("Invalid name");
            }
            name = name.substring(1, name.length() - 1);
            String value2 = regex.getAttributeValue("value");
            if (value2.length() == 1) continue;
            StringBuilder sb = new StringBuilder(name);
            sb.append(" = ");
            if (!value2.startsWith("(") || !value2.endsWith(")")) {
                throw new RuntimeException("Invalid value");
            }
            value2 = value2.substring(1, value2.length() - 1);
            char[] characterArray = value2.toCharArray();
            System.out.println("Value: " + value2);
            for (int i = 0; i < characterArray.length; ++i) {
                char charac = characterArray[i];
                sb.append(' ');
                if (charac == '(') {
                    sb.append('(');
                } else if (charac == ')') {
                    sb.append(')');
                } else if (charac == '%') {
                    Character nextChar;
                    int endOfRule = value2.indexOf(37, i + 1);
                    String rule = value2.substring(i + 1, value2.indexOf(37, i + 1));
                    Character c = nextChar = endOfRule + 1 < characterArray.length ? Character.valueOf(characterArray[endOfRule + 1]) : null;
                    if (nextChar != null) {
                        if (nextChar.charValue() == '?') {
                            sb.append("[ " + rule + " ]");
                            i = endOfRule + 1;
                        } else if (nextChar.charValue() == '*') {
                            sb.append("{ " + rule + " }");
                            i = endOfRule + 1;
                        } else if (nextChar.charValue() == '%') {
                            sb.append(rule + " ,");
                            i = endOfRule;
                        } else {
                            sb.append(rule);
                            i = endOfRule;
                        }
                    } else {
                        sb.append(rule);
                        i = endOfRule;
                    }
                } else if (charac == '|') {
                    sb.append('|');
                } else {
                    throw new RuntimeException("Unexpected character: " + charac);
                }
                sb.append(" ");
            }
            sb.append(" ;");
            System.out.println(sb.toString().replaceAll("\\s+", " "));
        }
    }
}

